/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.internal;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.preprocessor.CommandPreprocessingContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestion;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.SuggestionMapper;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.SuggestionProcessor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, consumers={"app.simplecloud.signs.plugin.relocate.incendo.cloud.*"})
public final class SuggestionContext<C, S extends Suggestion> {
    private final List<S> suggestions = new ArrayList<S>();
    private final CommandPreprocessingContext<C> preprocessingContext;
    private final SuggestionMapper<S> mapper;
    private final SuggestionProcessor<C> processor;
    private final CommandContext<C> commandContext;

    public SuggestionContext(@NonNull SuggestionProcessor<C> processor, @NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput, @NonNull SuggestionMapper<S> mapper) {
        this.processor = processor;
        this.commandContext = commandContext;
        this.preprocessingContext = CommandPreprocessingContext.of(this.commandContext, commandInput);
        this.mapper = mapper;
    }

    public @NonNull Suggestions<C, S> makeSuggestions() {
        Stream<Suggestion> processedStream;
        Stream<Suggestion> stream = this.suggestions.stream();
        List<Object> list = stream == (processedStream = this.processor.process(this.preprocessingContext, stream)) ? Collections.unmodifiableList(this.suggestions) : Collections.unmodifiableList(processedStream.peek(obj -> Objects.requireNonNull(obj, "suggestion")).map(this.mapper::map).collect(Collectors.toList()));
        return Suggestions.create(this.commandContext, list, this.preprocessingContext.commandInput());
    }

    public @NonNull CommandContext<C> commandContext() {
        return this.commandContext;
    }

    public void addSuggestions(@NonNull Iterable<? extends @NonNull Suggestion> suggestions) {
        suggestions.forEach(this::addSuggestion);
    }

    public void addSuggestion(@NonNull Suggestion suggestion) {
        Objects.requireNonNull(suggestion, "suggestion");
        this.suggestions.add(this.mapper.map(suggestion));
    }
}

