/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.NamespacedKeyParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.parser.RegistryEntryImpl;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.MappedArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestion;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.SuggestionProvider;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.immutables.value.Value;

@API(status=API.Status.EXPERIMENTAL)
public final class RegistryEntryParser<C, E extends Keyed>
implements ArgumentParser<C, RegistryEntry<E>>,
SuggestionProvider<C>,
MappedArgumentParser<C, NamespacedKey, RegistryEntry<E>> {
    private final ParserDescriptor<C, NamespacedKey> keyParser = NamespacedKeyParser.namespacedKeyParser();
    private final RegistryKey<E> registryKey;

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C, E extends Keyed> @NonNull ParserDescriptor<C, RegistryEntry<E>> registryEntryParser(RegistryKey<E> registryKey, TypeToken<E> elementType) {
        return ParserDescriptor.of(new RegistryEntryParser<C, E>(registryKey), TypeToken.get(TypeFactory.parameterizedClass(RegistryEntry.class, elementType.getType())));
    }

    public RegistryEntryParser(RegistryKey<E> registryKey) {
        this.registryKey = registryKey;
    }

    @Override
    public @NonNull ArgumentParseResult<RegistryEntry<@NonNull E>> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        return this.keyParser.parser().parse(commandContext, commandInput).flatMapSuccess((T key2) -> {
            Registry registry = RegistryAccess.registryAccess().getRegistry(this.registryKey);
            Keyed value = registry.get(key2);
            if (value == null) {
                return ArgumentParseResult.failure(new ParseException(key2.asString(), this.registryKey, commandContext));
            }
            return ArgumentParseResult.success(RegistryEntryImpl.of(value, key2));
        });
    }

    @Override
    public @NonNull ArgumentParser<C, NamespacedKey> baseParser() {
        return this.keyParser.parser();
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        ArrayList completions = new ArrayList();
        Registry registry = RegistryAccess.registryAccess().getRegistry(this.registryKey);
        registry.stream().map(arg_0 -> ((Registry)registry).getKeyOrThrow(arg_0)).forEach(key2 -> {
            if (input2.hasRemainingInput() && key2.getNamespace().equals("minecraft")) {
                completions.add(Suggestion.suggestion(key2.getKey()));
            }
            completions.add(Suggestion.suggestion(key2.getNamespace() + ':' + key2.getKey()));
        });
        return CompletableFuture.completedFuture(completions);
    }

    @Value.Immutable
    public static interface RegistryEntry<E> {
        public E value();

        public NamespacedKey key();
    }

    public static final class ParseException
    extends ParserException {
        private final String input;
        private final RegistryKey<Object> registryKey;

        public ParseException(@NonNull String input2, @NonNull RegistryKey<Object> registryKey, @NonNull CommandContext<?> context) {
            super(RegistryEntryParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_REGISTRY_ENTRY_MISSING, CaptionVariable.of("input", input2), CaptionVariable.of("registry", registryKey.key().asString()));
            this.input = input2;
            this.registryKey = registryKey;
        }

        public @NonNull String input() {
            return this.input;
        }

        public @NonNull RegistryKey<Object> registryKey() {
            return this.registryKey;
        }
    }
}

