/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.standard;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.NumberParseException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.standard.NumberParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.type.range.IntRange;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.type.range.Range;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public final class IntegerParser<C>
extends NumberParser<C, Integer, IntRange>
implements BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE)
    public static final int DEFAULT_MINIMUM = Integer.MIN_VALUE;
    @API(status=API.Status.STABLE)
    public static final int DEFAULT_MAXIMUM = Integer.MAX_VALUE;
    private static final int MAX_SUGGESTIONS_INCREMENT = 10;
    private static final int NUMBER_SHIFT_MULTIPLIER = 10;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Integer> integerParser() {
        return IntegerParser.integerParser(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Integer> integerParser(int minValue) {
        return ParserDescriptor.of(new IntegerParser<C>(minValue, Integer.MAX_VALUE), Integer.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Integer> integerParser(int minValue, int maxValue) {
        return ParserDescriptor.of(new IntegerParser<C>(minValue, maxValue), Integer.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Integer> integerComponent() {
        return CommandComponent.builder().parser(IntegerParser.integerParser());
    }

    public IntegerParser(int min2, int max) {
        super(Range.intRange(min2, max));
    }

    public static @NonNull List<@NonNull String> getSuggestions(@NonNull Range<? extends Number> range, @NonNull CommandInput input2) {
        TreeSet<Long> numbers = new TreeSet<Long>();
        String token = input2.peekString();
        try {
            long inputNum = Long.parseLong(token.equals("-") ? "-0" : (token.isEmpty() ? "0" : token));
            long inputNumAbsolute = Math.abs(inputNum);
            long min2 = range.min().longValue();
            long max = range.max().longValue();
            numbers.add(inputNumAbsolute);
            for (int i2 = 0; i2 < 10 && inputNum * 10L + (long)i2 <= max; ++i2) {
                numbers.add(inputNumAbsolute * 10L + (long)i2);
            }
            LinkedList<String> suggestions = new LinkedList<String>();
            Iterator iterator2 = numbers.iterator();
            while (iterator2.hasNext()) {
                long number = (Long)iterator2.next();
                if (token.startsWith("-")) {
                    number = -number;
                }
                if (number < min2 || number > max) continue;
                suggestions.add(String.valueOf(number));
            }
            return suggestions;
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
    }

    @Override
    public @NonNull ArgumentParseResult<Integer> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidInteger((IntRange)this.range())) {
            return ArgumentParseResult.failure(new IntegerParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readInteger());
    }

    @Override
    public boolean hasMax() {
        return ((IntRange)this.range()).maxInt() != Integer.MAX_VALUE;
    }

    @Override
    public boolean hasMin() {
        return ((IntRange)this.range()).minInt() != Integer.MIN_VALUE;
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        return IntegerParser.getSuggestions(this.range(), input2);
    }

    @API(status=API.Status.STABLE)
    public static final class IntegerParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public IntegerParseException(@NonNull String input2, @NonNull IntegerParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input2, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "integer";
        }
    }
}

