/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.cache;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.cache.CloudCache;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE, since="1.0.0")
public final class SimpleCache<K, V>
implements CloudCache<K, V> {
    private final Map<K, V> map = Collections.synchronizedMap(new WeakHashMap());

    public static <K, V> @NonNull CloudCache<K, V> of() {
        return new SimpleCache<K, V>();
    }

    @Override
    public void delete(@NonNull K key2) {
        Objects.requireNonNull(key2, "key");
        this.map.remove(key2);
    }

    @Override
    public void put(@NonNull K key2, @NonNull V value) {
        Objects.requireNonNull(key2, "key");
        Objects.requireNonNull(value, "value");
        this.map.put(key2, value);
    }

    @Override
    public @Nullable V getIfPresent(@NonNull K key2) {
        Objects.requireNonNull(key2, "key");
        return this.map.get(key2);
    }

    @Override
    public @Nullable V popIfPresent(@NonNull K key2) {
        Objects.requireNonNull(key2, "key");
        return this.map.remove(key2);
    }
}

