/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.spongepowered.configurate.transformation;

import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.ConfigurateException;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.NodePath;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.transformation.ConfigurationTransformation;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.transformation.MoveStrategy;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.transformation.MutableNodePath;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.transformation.TransformAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SingleConfigurationTransformation
implements ConfigurationTransformation {
    private final MoveStrategy strategy;
    private final Map<NodePath, TransformAction> actions;
    private final ThreadLocal<MutableNodePath> sharedPath = ThreadLocal.withInitial(MutableNodePath::new);

    SingleConfigurationTransformation(Map<NodePath, TransformAction> actions, MoveStrategy strategy) {
        this.actions = actions;
        this.strategy = strategy;
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (Map.Entry<NodePath, TransformAction> ent : this.actions.entrySet()) {
            try {
                this.applySingleAction(node, ent.getKey().array(), 0, node, ent.getValue());
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    private void applySingleAction(ConfigurationNode start2, Object[] path2, int startIdx, ConfigurationNode node, TransformAction action) throws ConfigurateException {
        ConfigurateException thrown = null;
        for (int i2 = startIdx; i2 < path2.length; ++i2) {
            if (path2[i2] == WILDCARD_OBJECT) {
                if (node.isList()) {
                    List<? extends ConfigurationNode> children2 = node.childrenList();
                    for (int di = 0; di < children2.size(); ++di) {
                        path2[i2] = di;
                        try {
                            this.applySingleAction(start2, path2, i2 + 1, children2.get(di), action);
                            continue;
                        }
                        catch (ConfigurateException ex) {
                            if (thrown == null) {
                                thrown = ex;
                                continue;
                            }
                            thrown.addSuppressed(ex);
                        }
                    }
                    path2[i2] = WILDCARD_OBJECT;
                } else if (node.isMap()) {
                    for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.childrenMap().entrySet()) {
                        path2[i2] = ent.getKey();
                        try {
                            this.applySingleAction(start2, path2, i2 + 1, ent.getValue(), action);
                        }
                        catch (ConfigurateException ex) {
                            if (thrown == null) {
                                thrown = ex;
                                continue;
                            }
                            thrown.addSuppressed(ex);
                        }
                    }
                    path2[i2] = WILDCARD_OBJECT;
                } else {
                    return;
                }
                return;
            }
            if (!(node = node.node(path2[i2])).virtual()) continue;
            return;
        }
        MutableNodePath nodePath = this.sharedPath.get();
        nodePath.arr = path2;
        Object @Nullable [] transformedPath = action.visitPath(nodePath, node);
        if (transformedPath != null && !Arrays.equals(path2, transformedPath)) {
            this.strategy.move(node, start2.node(transformedPath));
            node.raw(null);
        }
    }
}

