/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.transform.EasingFunction;
import com.github.ajalt.colormath.transform.InterpolateKt;
import com.github.ajalt.colormath.transform.InterpolationMethod;
import com.github.ajalt.colormath.transform.Interpolator;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001bB9\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/ajalt/colormath/transform/InterpolatorImpl;", "T", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/transform/Interpolator;", "lerps", "", "Lcom/github/ajalt/colormath/transform/InterpolationMethod$ComponentInterpolator;", "easing", "Lcom/github/ajalt/colormath/transform/InterpolatorImpl$Easing;", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "premultiplyAlpha", "", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/github/ajalt/colormath/ColorSpace;Z)V", "out", "", "interpolate", "t", "", "(Ljava/lang/Number;)Lcom/github/ajalt/colormath/Color;", "lerpEdgecase", "", "", "lerpEased", "li", "", "Easing", "colormath"})
@SourceDebugExtension(value={"SMAP\nInterpolate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolatorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,449:1\n1734#2,3:450\n388#2,7:453\n*S KotlinDebug\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolatorImpl\n*L\n219#1:450,3\n226#1:453,7\n*E\n"})
final class InterpolatorImpl<T extends Color>
implements Interpolator<T> {
    @NotNull
    private final List<InterpolationMethod.ComponentInterpolator> lerps;
    @NotNull
    private final List<Easing> easing;
    @NotNull
    private final ColorSpace<T> space;
    private final boolean premultiplyAlpha;
    @NotNull
    private final float[] out;

    public InterpolatorImpl(@NotNull List<? extends InterpolationMethod.ComponentInterpolator> lerps, @NotNull List<Easing> easing, @NotNull ColorSpace<T> space, boolean premultiplyAlpha) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(lerps, "lerps");
            Intrinsics.checkNotNullParameter(easing, "easing");
            Intrinsics.checkNotNullParameter(space, "space");
            this.lerps = lerps;
            this.easing = easing;
            this.space = space;
            this.premultiplyAlpha = premultiplyAlpha;
            if (!(this.lerps.size() == this.space.getComponents().size())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Iterable $this$all$iv = this.easing;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Easing it = (Easing)element$iv;
                    boolean bl2 = false;
                    if (it.getFns().size() == this.space.getComponents().size()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.out = new float[this.space.getComponents().size()];
    }

    @Override
    @NotNull
    public T interpolate(@NotNull Number t2) {
        int li;
        float tf;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter(t2, "t");
            tf = t2.floatValue();
            List<Easing> $this$indexOfLast$iv = this.easing;
            boolean $i$f$indexOfLast = false;
            ListIterator<Easing> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Easing it = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getPosition() <= tf)) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = li = -1;
        }
        if (li < 0 || li == CollectionsKt.getLastIndex(this.easing) || this.easing.get(li).getPosition() == tf) {
            this.lerpEdgecase(tf);
        } else {
            this.lerpEased(li, tf);
        }
        InterpolateKt.access$div(this.space, this.premultiplyAlpha, this.out);
        return this.space.create(this.out);
    }

    private final void lerpEdgecase(float t2) {
        int n = this.out.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.out[i2] = this.lerps.get(i2).interpolate(t2);
        }
    }

    private final void lerpEased(int li, float t2) {
        float lx = this.easing.get(li).getPosition();
        float rx = this.easing.get(li + 1).getPosition();
        float t1 = InternalMathKt.scaleRange(lx, rx, 0.0f, 1.0f, t2);
        int n = this.out.length;
        for (int i2 = 0; i2 < n; ++i2) {
            float te = this.easing.get(li).getFns().get(i2).ease(t1);
            float tf = InternalMathKt.scaleRange(0.0f, 1.0f, lx, rx, te);
            this.out[i2] = this.lerps.get(i2).interpolate(tf);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/github/ajalt/colormath/transform/InterpolatorImpl$Easing;", "", "position", "", "fns", "", "Lcom/github/ajalt/colormath/transform/EasingFunction;", "<init>", "(FLjava/util/List;)V", "getPosition", "()F", "getFns", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "colormath"})
    public static final class Easing {
        private final float position;
        @NotNull
        private final List<EasingFunction> fns;

        public Easing(float position, @NotNull List<? extends EasingFunction> fns) {
            Intrinsics.checkNotNullParameter(fns, "fns");
            this.position = position;
            this.fns = fns;
        }

        public final float getPosition() {
            return this.position;
        }

        @NotNull
        public final List<EasingFunction> getFns() {
            return this.fns;
        }

        public final float component1() {
            return this.position;
        }

        @NotNull
        public final List<EasingFunction> component2() {
            return this.fns;
        }

        @NotNull
        public final Easing copy(float position, @NotNull List<? extends EasingFunction> fns) {
            Intrinsics.checkNotNullParameter(fns, "fns");
            return new Easing(position, fns);
        }

        public static /* synthetic */ Easing copy$default(Easing easing, float f, List list, int n, Object object) {
            if ((n & 1) != 0) {
                f = easing.position;
            }
            if ((n & 2) != 0) {
                list = easing.fns;
            }
            return easing.copy(f, list);
        }

        @NotNull
        public String toString() {
            return "Easing(position=" + this.position + ", fns=" + this.fns + ')';
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.position);
            result2 = result2 * 31 + ((Object)this.fns).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Easing)) {
                return false;
            }
            Easing easing = (Easing)other;
            if (Float.compare(this.position, easing.position) != 0) {
                return false;
            }
            return Intrinsics.areEqual(this.fns, easing.fns);
        }
    }
}

