/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.CodecsKt;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.auth.HeaderValueEncoding;
import io.ktor.http.auth.HttpAuthHeaderKt;
import io.ktor.http.parsing.ParseException;
import io.ktor.util.CryptoKt;
import io.ktor.util.Hash;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000f\u0010\u000e\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\b\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\b\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\n\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lio/ktor/http/auth/HttpAuthHeader;", "", "", "authScheme", "<init>", "(Ljava/lang/String;)V", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "render", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "()Ljava/lang/String;", "toString", "Ljava/lang/String;", "getAuthScheme", "Companion", "Single", "Parameterized", "Parameters", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/http/auth/HttpAuthHeader$Single;", "ktor-http"})
public abstract class HttpAuthHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String authScheme;

    private HttpAuthHeader(String authScheme) {
        this.authScheme = authScheme;
        CharSequence charSequence = this.authScheme;
        if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence)) {
            throw new ParseException("Invalid authScheme value: it should be token, but instead it is " + this.authScheme, null, 2, null);
        }
    }

    @NotNull
    public final String getAuthScheme() {
        return this.authScheme;
    }

    @NotNull
    public abstract String render(@NotNull HeaderValueEncoding var1);

    @NotNull
    public abstract String render();

    @NotNull
    public String toString() {
        return this.render();
    }

    public /* synthetic */ HttpAuthHeader(String authScheme, DefaultConstructorMarker $constructor_marker) {
        this(authScheme);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJQ\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u00042\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Companion;", "", "<init>", "()V", "", "realm", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "charset", "Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "basicAuthChallenge", "(Ljava/lang/String;Ljava/nio/charset/Charset;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "scheme", "Lio/ktor/http/auth/HttpAuthHeader;", "bearerAuthChallenge", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader;", "nonce", "", "domain", "opaque", "", "stale", "algorithm", "digestAuthChallenge", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Parameterized basicAuthChallenge(@NotNull String realm, @Nullable Charset charset) {
            void $this$basicAuthChallenge_u24lambda_u240;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter(realm, "realm");
            LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
            String string = "Basic";
            boolean bl = false;
            $this$basicAuthChallenge_u24lambda_u240.put("realm", realm);
            if (charset != null) {
                $this$basicAuthChallenge_u24lambda_u240.put("charset", CharsetJVMKt.getName(charset));
            }
            DefaultConstructorMarker defaultConstructorMarker2 = null;
            int n = 4;
            HeaderValueEncoding headerValueEncoding = null;
            Map map2 = linkedHashMap;
            String string2 = string;
            return new Parameterized(string2, map2, headerValueEncoding, n, defaultConstructorMarker2);
        }

        @NotNull
        public final HttpAuthHeader bearerAuthChallenge(@NotNull String scheme, @Nullable String realm) {
            Intrinsics.checkNotNullParameter(scheme, "scheme");
            return new Parameterized(scheme, realm == null ? MapsKt.emptyMap() : MapsKt.mapOf(TuplesKt.to("realm", realm)), null, 4, null);
        }

        public static /* synthetic */ HttpAuthHeader bearerAuthChallenge$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.bearerAuthChallenge(string, string2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Parameterized digestAuthChallenge(@NotNull String realm, @NotNull String nonce, @NotNull List<String> domain, @Nullable String opaque, @Nullable Boolean stale, @NotNull String algorithm) {
            void $this$digestAuthChallenge_u24lambda_u241;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter(realm, "realm");
            Intrinsics.checkNotNullParameter(nonce, "nonce");
            Intrinsics.checkNotNullParameter(domain, "domain");
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            LinkedHashMap linkedHashMap2 = linkedHashMap = new LinkedHashMap();
            String string = "Digest";
            boolean bl = false;
            $this$digestAuthChallenge_u24lambda_u241.put("realm", HeaderValueWithParametersKt.quote(realm));
            $this$digestAuthChallenge_u24lambda_u241.put("nonce", HeaderValueWithParametersKt.quote(nonce));
            if (!((Collection)domain).isEmpty()) {
                $this$digestAuthChallenge_u24lambda_u241.put("domain", HeaderValueWithParametersKt.quote(CollectionsKt.joinToString$default(domain, " ", null, null, 0, null, null, 62, null)));
            }
            if (opaque != null) {
                $this$digestAuthChallenge_u24lambda_u241.put("opaque", HeaderValueWithParametersKt.quote(opaque));
            }
            if (stale != null) {
                $this$digestAuthChallenge_u24lambda_u241.put("stale", stale.toString());
            }
            $this$digestAuthChallenge_u24lambda_u241.put("algorithm", algorithm);
            HeaderValueEncoding headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            Map map2 = linkedHashMap;
            String string2 = string;
            return new Parameterized(string2, map2, headerValueEncoding);
        }

        public static /* synthetic */ Parameterized digestAuthChallenge$default(Companion companion, String string, String string2, List list, String string3, Boolean bl, String string4, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = CryptoKt.generateNonce();
            }
            if ((n & 4) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                bl = null;
            }
            if ((n & 0x20) != 0) {
                string4 = "MD5";
            }
            return companion.digestAuthChallenge(string, string2, list, string3, bl, string4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u000b\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0016\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "Lio/ktor/http/auth/HttpAuthHeader;", "", "authScheme", "", "Lio/ktor/http/HeaderValueParam;", "parameters", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "<init>", "(Ljava/lang/String;Ljava/util/List;Lio/ktor/http/auth/HeaderValueEncoding;)V", "", "(Ljava/lang/String;Ljava/util/Map;Lio/ktor/http/auth/HeaderValueEncoding;)V", "name", "value", "withParameter", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/http/auth/HttpAuthHeader$Parameterized;", "withReplacedParameter", "render", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "parameter", "(Ljava/lang/String;)Ljava/lang/String;", "encode", "(Ljava/lang/String;Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "()Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/util/List;", "getParameters", "()Ljava/util/List;", "Lio/ktor/http/auth/HeaderValueEncoding;", "getEncoding", "()Lio/ktor/http/auth/HeaderValueEncoding;", "ktor-http"})
    @SourceDebugExtension(value={"SMAP\nHttpAuthHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpAuthHeader.kt\nio/ktor/http/auth/HttpAuthHeader$Parameterized\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,464:1\n1863#2,2:465\n1557#2:467\n1628#2,3:468\n360#2,7:471\n1611#2,9:478\n1863#2:487\n1864#2:489\n1620#2:490\n295#2,2:491\n1#3:488\n*S KotlinDebug\n*F\n+ 1 HttpAuthHeader.kt\nio/ktor/http/auth/HttpAuthHeader$Parameterized\n*L\n279#1:465,2\n276#1:467\n276#1:468,3\n299#1:471,7\n303#1:478,9\n303#1:487\n303#1:489\n303#1:490\n326#1:491,2\n303#1:488\n*E\n"})
    public static final class Parameterized
    extends HttpAuthHeader {
        @NotNull
        private final List<HeaderValueParam> parameters;
        @NotNull
        private final HeaderValueEncoding encoding;

        public Parameterized(@NotNull String authScheme, @NotNull List<HeaderValueParam> parameters, @NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkNotNullParameter(authScheme, "authScheme");
            Intrinsics.checkNotNullParameter(parameters, "parameters");
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            super(authScheme, null);
            this.parameters = parameters;
            this.encoding = encoding;
            Iterable $this$forEach$iv = this.parameters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeaderValueParam it = (HeaderValueParam)element$iv;
                boolean bl = false;
                CharSequence charSequence = it.getName();
                if (HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence)) continue;
                throw new ParseException("Parameter name should be a token", null, 2, null);
            }
        }

        public /* synthetic */ Parameterized(String string, List list, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, list, headerValueEncoding);
        }

        @NotNull
        public final List<HeaderValueParam> getParameters() {
            return this.parameters;
        }

        @NotNull
        public final HeaderValueEncoding getEncoding() {
            return this.encoding;
        }

        /*
         * WARNING - void declaration
         */
        public Parameterized(@NotNull String authScheme, @NotNull Map<String, String> parameters, @NotNull HeaderValueEncoding encoding) {
            Collection<HeaderValueParam> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(authScheme, "authScheme");
            Intrinsics.checkNotNullParameter(parameters, "parameters");
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            Iterable iterable = parameters.entrySet();
            String string = authScheme;
            Parameterized parameterized = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new HeaderValueParam((String)it.getKey(), (String)it.getValue()));
            }
            collection = (List)destination$iv$iv;
            parameterized(string, (List<HeaderValueParam>)collection, encoding);
        }

        public /* synthetic */ Parameterized(String string, Map map2, HeaderValueEncoding headerValueEncoding, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 4) != 0) {
                headerValueEncoding = HeaderValueEncoding.QUOTED_WHEN_REQUIRED;
            }
            this(string, map2, headerValueEncoding);
        }

        @NotNull
        public final Parameterized withParameter(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            return new Parameterized(this.getAuthScheme(), CollectionsKt.plus((Collection)this.parameters, new HeaderValueParam(name, value)), this.encoding);
        }

        @NotNull
        public final Parameterized withReplacedParameter(@NotNull String name, @NotNull String value) {
            int firstIndex;
            block8: {
                int n;
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(value, "value");
                List<HeaderValueParam> $this$indexOfFirst$iv = this.parameters;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<HeaderValueParam> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    HeaderValueParam headerValueParam;
                    HeaderValueParam it = headerValueParam = iterator2.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual(it.getName(), name)) {
                        n = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n = firstIndex = -1;
            }
            if (firstIndex == -1) {
                return this.withParameter(name, value);
            }
            boolean replaced = false;
            Iterable $this$mapNotNull$iv = this.parameters;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = iterable;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                HeaderValueParam headerValueParam;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                HeaderValueParam it = (HeaderValueParam)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getName(), name)) {
                    headerValueParam = it;
                } else if (!replaced) {
                    replaced = true;
                    headerValueParam = new HeaderValueParam(name, value);
                } else {
                    headerValueParam = null;
                }
                if (headerValueParam == null) continue;
                HeaderValueParam it$iv$iv = headerValueParam;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List newParameters = (List)destination$iv$iv;
            return new Parameterized(this.getAuthScheme(), newParameters, this.encoding);
        }

        @Override
        @NotNull
        public String render(@NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            return this.parameters.isEmpty() ? this.getAuthScheme() : CollectionsKt.joinToString$default(this.parameters, ", ", this.getAuthScheme() + ' ', null, 0, null, arg_0 -> Parameterized.render$lambda$4(this, encoding, arg_0), 28, null);
        }

        @Nullable
        public final String parameter(@NotNull String name) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(name, "name");
                Iterable $this$firstOrNull$iv = this.parameters;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HeaderValueParam it = (HeaderValueParam)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), name)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            HeaderValueParam headerValueParam = v0;
            return headerValueParam != null ? headerValueParam.getValue() : null;
        }

        private final String encode(String $this$encode, HeaderValueEncoding encoding) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
                case 1: {
                    string = HeaderValueWithParametersKt.escapeIfNeeded($this$encode);
                    break;
                }
                case 2: {
                    string = HeaderValueWithParametersKt.quote($this$encode);
                    break;
                }
                case 3: {
                    string = CodecsKt.encodeURLParameter$default($this$encode, false, 1, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Override
        @NotNull
        public String render() {
            return this.render(this.encoding);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Parameterized)) {
                return false;
            }
            return StringsKt.equals(((Parameterized)other).getAuthScheme(), this.getAuthScheme(), true) && Intrinsics.areEqual(((Parameterized)other).parameters, this.parameters);
        }

        public int hashCode() {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue(this.getAuthScheme().toLowerCase(Locale.ROOT), "toLowerCase(...)");
            objectArray[1] = this.parameters;
            return Hash.INSTANCE.combine(objectArray);
        }

        private static final CharSequence render$lambda$4(Parameterized this$0, HeaderValueEncoding $encoding, HeaderValueParam it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getName() + '=' + this$0.encode(it.getValue(), $encoding);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HeaderValueEncoding.values().length];
                try {
                    nArray[HeaderValueEncoding.QUOTED_WHEN_REQUIRED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderValueEncoding.QUOTED_ALWAYS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HeaderValueEncoding.URI_ENCODE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Parameters;", "", "<init>", "()V", "", "Realm", "Ljava/lang/String;", "Charset", "OAuthCallback", "OAuthConsumerKey", "OAuthNonce", "OAuthToken", "OAuthTokenSecret", "OAuthVerifier", "OAuthSignatureMethod", "OAuthTimestamp", "OAuthVersion", "OAuthSignature", "OAuthCallbackConfirmed", "ktor-http"})
    public static final class Parameters {
        @NotNull
        public static final Parameters INSTANCE = new Parameters();
        @NotNull
        public static final String Realm = "realm";
        @NotNull
        public static final String Charset = "charset";
        @NotNull
        public static final String OAuthCallback = "oauth_callback";
        @NotNull
        public static final String OAuthConsumerKey = "oauth_consumer_key";
        @NotNull
        public static final String OAuthNonce = "oauth_nonce";
        @NotNull
        public static final String OAuthToken = "oauth_token";
        @NotNull
        public static final String OAuthTokenSecret = "oauth_token_secret";
        @NotNull
        public static final String OAuthVerifier = "oauth_verifier";
        @NotNull
        public static final String OAuthSignatureMethod = "oauth_signature_method";
        @NotNull
        public static final String OAuthTimestamp = "oauth_timestamp";
        @NotNull
        public static final String OAuthVersion = "oauth_version";
        @NotNull
        public static final String OAuthSignature = "oauth_signature";
        @NotNull
        public static final String OAuthCallbackConfirmed = "oauth_callback_confirmed";

        private Parameters() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/ktor/http/auth/HttpAuthHeader$Single;", "Lio/ktor/http/auth/HttpAuthHeader;", "", "authScheme", "blob", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "render", "()Ljava/lang/String;", "Lio/ktor/http/auth/HeaderValueEncoding;", "encoding", "(Lio/ktor/http/auth/HeaderValueEncoding;)Ljava/lang/String;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getBlob", "ktor-http"})
    public static final class Single
    extends HttpAuthHeader {
        @NotNull
        private final String blob;

        public Single(@NotNull String authScheme, @NotNull String blob) {
            Intrinsics.checkNotNullParameter(authScheme, "authScheme");
            Intrinsics.checkNotNullParameter(blob, "blob");
            super(authScheme, null);
            this.blob = blob;
            CharSequence charSequence = this.blob;
            if (!HttpAuthHeaderKt.access$getToken68Pattern$p().matches(charSequence)) {
                throw new ParseException("Invalid blob value: it should be token68", null, 2, null);
            }
        }

        @NotNull
        public final String getBlob() {
            return this.blob;
        }

        @Override
        @NotNull
        public String render() {
            return this.getAuthScheme() + ' ' + this.blob;
        }

        @Override
        @NotNull
        public String render(@NotNull HeaderValueEncoding encoding) {
            Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
            return this.render();
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Single)) {
                return false;
            }
            return StringsKt.equals(((Single)other).getAuthScheme(), this.getAuthScheme(), true) && StringsKt.equals(((Single)other).blob, this.blob, true);
        }

        public int hashCode() {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue(this.getAuthScheme().toLowerCase(Locale.ROOT), "toLowerCase(...)");
            Intrinsics.checkNotNullExpressionValue(this.blob.toLowerCase(Locale.ROOT), "toLowerCase(...)");
            return Hash.INSTANCE.combine(objectArray);
        }
    }
}

