/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.cache;

import app.simplecloud.relocate.google.common.annotations.GwtIncompatible;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.cache.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.cache.ForwardingCache;
import app.simplecloud.relocate.google.common.cache.LoadingCache;
import app.simplecloud.relocate.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ForwardingLoadingCache<K, V>
extends ForwardingCache<K, V>
implements LoadingCache<K, V> {
    protected ForwardingLoadingCache() {
    }

    @Override
    protected abstract LoadingCache<K, V> delegate();

    @Override
    @CanIgnoreReturnValue
    public V get(K key2) throws ExecutionException {
        return this.delegate().get(key2);
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key2) {
        return this.delegate().getUnchecked(key2);
    }

    @Override
    @CanIgnoreReturnValue
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys2) throws ExecutionException {
        return this.delegate().getAll(keys2);
    }

    @Override
    public V apply(K key2) {
        return this.delegate().apply(key2);
    }

    @Override
    public void refresh(K key2) {
        this.delegate().refresh(key2);
    }

    public static abstract class SimpleForwardingLoadingCache<K, V>
    extends ForwardingLoadingCache<K, V> {
        private final LoadingCache<K, V> delegate;

        protected SimpleForwardingLoadingCache(LoadingCache<K, V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final LoadingCache<K, V> delegate() {
            return this.delegate;
        }
    }
}

