/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.collect;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.base.Predicate;
import app.simplecloud.relocate.google.common.collect.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.collect.FilteredEntryMultimap;
import app.simplecloud.relocate.google.common.collect.FilteredSetMultimap;
import app.simplecloud.relocate.google.common.collect.ParametricNullness;
import app.simplecloud.relocate.google.common.collect.SetMultimap;
import app.simplecloud.relocate.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class FilteredEntrySetMultimap<K, V>
extends FilteredEntryMultimap<K, V>
implements FilteredSetMultimap<K, V> {
    FilteredEntrySetMultimap(SetMultimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
        super(unfiltered, predicate);
    }

    @Override
    public SetMultimap<K, V> unfiltered() {
        return (SetMultimap)this.unfiltered;
    }

    @Override
    public Set<V> get(@ParametricNullness K key2) {
        return (Set)super.get(key2);
    }

    @Override
    public Set<V> removeAll(@CheckForNull Object key2) {
        return (Set)super.removeAll(key2);
    }

    @Override
    public Set<V> replaceValues(@ParametricNullness K key2, Iterable<? extends V> values2) {
        return (Set)super.replaceValues(key2, values2);
    }

    @Override
    Set<Map.Entry<K, V>> createEntries() {
        return Sets.filter(this.unfiltered().entries(), this.entryPredicate());
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }
}

