/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.buffer.search;

import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.buffer.search.AbstractSearchProcessorFactory;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.buffer.search.SearchProcessor;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;

public class KmpSearchProcessorFactory
extends AbstractSearchProcessorFactory {
    private final int[] jumpTable;
    private final byte[] needle;

    KmpSearchProcessorFactory(byte[] needle) {
        this.needle = (byte[])needle.clone();
        this.jumpTable = new int[needle.length + 1];
        int j = 0;
        for (int i2 = 1; i2 < needle.length; ++i2) {
            while (j > 0 && needle[j] != needle[i2]) {
                j = this.jumpTable[j];
            }
            if (needle[j] == needle[i2]) {
                // empty if block
            }
            this.jumpTable[i2 + 1] = ++j;
        }
    }

    @Override
    public Processor newSearchProcessor() {
        return new Processor(this.needle, this.jumpTable);
    }

    public static class Processor
    implements SearchProcessor {
        private final byte[] needle;
        private final int[] jumpTable;
        private long currentPosition;

        Processor(byte[] needle, int[] jumpTable) {
            this.needle = needle;
            this.jumpTable = jumpTable;
        }

        @Override
        public boolean process(byte value) {
            while (this.currentPosition > 0L && PlatformDependent.getByte(this.needle, this.currentPosition) != value) {
                this.currentPosition = PlatformDependent.getInt(this.jumpTable, this.currentPosition);
            }
            if (PlatformDependent.getByte(this.needle, this.currentPosition) == value) {
                ++this.currentPosition;
            }
            if (this.currentPosition == (long)this.needle.length) {
                this.currentPosition = PlatformDependent.getInt(this.jumpTable, this.currentPosition);
                return false;
            }
            return true;
        }

        @Override
        public void reset() {
            this.currentPosition = 0L;
        }
    }
}

