/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart;

import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpConstants;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.Attribute;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.DiskAttribute;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.DiskFileUpload;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.FileUpload;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpData;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.HttpDataFactory;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.MemoryAttribute;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.MemoryFileUpload;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.MixedAttribute;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.multipart.MixedFileUpload;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultHttpDataFactory
implements HttpDataFactory {
    public static final long MINSIZE = 16384L;
    public static final long MAXSIZE = -1L;
    private final boolean useDisk;
    private final boolean checkSize;
    private long minSize;
    private long maxSize = -1L;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private String baseDir;
    private boolean deleteOnExit;
    private final Map<HttpRequest, List<HttpData>> requestFileDeleteMap = Collections.synchronizedMap(new IdentityHashMap());

    public DefaultHttpDataFactory() {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = 16384L;
    }

    public DefaultHttpDataFactory(Charset charset) {
        this();
        this.charset = charset;
    }

    public DefaultHttpDataFactory(boolean useDisk) {
        this.useDisk = useDisk;
        this.checkSize = false;
    }

    public DefaultHttpDataFactory(boolean useDisk, Charset charset) {
        this(useDisk);
        this.charset = charset;
    }

    public DefaultHttpDataFactory(long minSize) {
        this.useDisk = false;
        this.checkSize = true;
        this.minSize = minSize;
    }

    public DefaultHttpDataFactory(long minSize, Charset charset) {
        this(minSize);
        this.charset = charset;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    @Override
    public void setMaxLimit(long maxSize) {
        this.maxSize = maxSize;
    }

    private List<HttpData> getList(HttpRequest request2) {
        List<HttpData> list = this.requestFileDeleteMap.get(request2);
        if (list == null) {
            list = new ArrayList<HttpData>();
            this.requestFileDeleteMap.put(request2, list);
        }
        return list;
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name) {
        if (this.useDisk) {
            DiskAttribute attribute = new DiskAttribute(name, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(request2);
            list.add(attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(request2);
            list.add(attribute);
            return attribute;
        }
        MemoryAttribute attribute = new MemoryAttribute(name);
        attribute.setMaxSize(this.maxSize);
        return attribute;
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name, long definedSize) {
        if (this.useDisk) {
            DiskAttribute attribute = new DiskAttribute(name, definedSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(request2);
            list.add(attribute);
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, definedSize, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            List<HttpData> list = this.getList(request2);
            list.add(attribute);
            return attribute;
        }
        MemoryAttribute attribute = new MemoryAttribute(name, definedSize);
        attribute.setMaxSize(this.maxSize);
        return attribute;
    }

    private static void checkHttpDataSize(HttpData data) {
        try {
            data.checkSize(data.length());
        }
        catch (IOException ignored) {
            throw new IllegalArgumentException("Attribute bigger than maxSize allowed");
        }
    }

    @Override
    public Attribute createAttribute(HttpRequest request2, String name, String value) {
        if (this.useDisk) {
            AbstractReferenceCounted attribute;
            try {
                attribute = new DiskAttribute(name, value, this.charset, this.baseDir, this.deleteOnExit);
                attribute.setMaxSize(this.maxSize);
            }
            catch (IOException e) {
                attribute = new MixedAttribute(name, value, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
                attribute.setMaxSize(this.maxSize);
            }
            DefaultHttpDataFactory.checkHttpDataSize((HttpData)((Object)attribute));
            List<HttpData> list = this.getList(request2);
            list.add((HttpData)((Object)attribute));
            return attribute;
        }
        if (this.checkSize) {
            MixedAttribute attribute = new MixedAttribute(name, value, this.minSize, this.charset, this.baseDir, this.deleteOnExit);
            attribute.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(attribute);
            List<HttpData> list = this.getList(request2);
            list.add(attribute);
            return attribute;
        }
        try {
            MemoryAttribute attribute = new MemoryAttribute(name, value, this.charset);
            attribute.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(attribute);
            return attribute;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileUpload createFileUpload(HttpRequest request2, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        if (this.useDisk) {
            DiskFileUpload fileUpload = new DiskFileUpload(name, filename, contentType, contentTransferEncoding, charset, size, this.baseDir, this.deleteOnExit);
            fileUpload.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
            List<HttpData> list = this.getList(request2);
            list.add(fileUpload);
            return fileUpload;
        }
        if (this.checkSize) {
            MixedFileUpload fileUpload = new MixedFileUpload(name, filename, contentType, contentTransferEncoding, charset, size, this.minSize, this.baseDir, this.deleteOnExit);
            fileUpload.setMaxSize(this.maxSize);
            DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
            List<HttpData> list = this.getList(request2);
            list.add(fileUpload);
            return fileUpload;
        }
        MemoryFileUpload fileUpload = new MemoryFileUpload(name, filename, contentType, contentTransferEncoding, charset, size);
        fileUpload.setMaxSize(this.maxSize);
        DefaultHttpDataFactory.checkHttpDataSize(fileUpload);
        return fileUpload;
    }

    @Override
    public void removeHttpDataFromClean(HttpRequest request2, InterfaceHttpData data) {
        if (!(data instanceof HttpData)) {
            return;
        }
        List<HttpData> list = this.requestFileDeleteMap.get(request2);
        if (list == null) {
            return;
        }
        Iterator<HttpData> i2 = list.iterator();
        while (i2.hasNext()) {
            HttpData n = i2.next();
            if (n != data) continue;
            i2.remove();
            if (list.isEmpty()) {
                this.requestFileDeleteMap.remove(request2);
            }
            return;
        }
    }

    @Override
    public void cleanRequestHttpData(HttpRequest request2) {
        List<HttpData> list = this.requestFileDeleteMap.remove(request2);
        if (list != null) {
            for (HttpData data : list) {
                data.release();
            }
        }
    }

    @Override
    public void cleanAllHttpData() {
        Iterator<Map.Entry<HttpRequest, List<HttpData>>> i2 = this.requestFileDeleteMap.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry<HttpRequest, List<HttpData>> e = i2.next();
            List<HttpData> list = e.getValue();
            for (HttpData data : list) {
                data.release();
            }
            i2.remove();
        }
    }

    @Override
    public void cleanRequestHttpDatas(HttpRequest request2) {
        this.cleanRequestHttpData(request2);
    }

    @Override
    public void cleanAllHttpDatas() {
        this.cleanAllHttpData();
    }
}

