/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.suggestion;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.CommandManager;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.CloudBrigadierCommand;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.CloudBrigadierManager;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.internal.CommandNode;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.SuggestionFactory;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.INTERNAL, since="2.0.0")
public final class BrigadierSuggestionFactory<C, S> {
    private final CloudBrigadierManager<C, S> cloudBrigadierManager;
    private final CommandManager<C> commandManager;
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    public BrigadierSuggestionFactory(@NonNull CloudBrigadierManager<C, S> cloudBrigadierManager, @NonNull CommandManager<C> commandManager, @NonNull SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory) {
        this.cloudBrigadierManager = cloudBrigadierManager;
        this.commandManager = commandManager;
        this.suggestionFactory = suggestionFactory;
    }

    public @NonNull CompletableFuture<@NonNull Suggestions> buildSuggestions(@NonNull CommandContext<S> senderContext, @Nullable CommandNode<C> parentNode, @NonNull SuggestionsBuilder builder2) {
        C cloudSender = this.cloudBrigadierManager.senderMapper().map(senderContext.getSource());
        app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext<C> commandContext = new app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext<C>(true, cloudSender, this.commandManager);
        commandContext.store("_cloud_brigadier_native_sender", senderContext.getSource());
        String command2 = builder2.getInput().substring(CloudBrigadierCommand.parsedNodes(senderContext.getLastChild()).get(0).second().getStart());
        String leading = command2.split(" ")[0];
        if (leading.contains(":")) {
            command2 = command2.substring(leading.split(":")[0].length() + 1);
        }
        return this.suggestionFactory.suggest(commandContext.sender(), command2).thenApply(suggestionsResult -> {
            ArrayList suggestions = new ArrayList(suggestionsResult.list());
            if (parentNode != null) {
                Set siblingLiterals = parentNode.children().stream().map(CommandNode::component).filter(Objects::nonNull).filter(c -> c.type() == CommandComponent.ComponentType.LITERAL).flatMap(commandComponent -> commandComponent.aliases().stream()).collect(Collectors.toSet());
                suggestions.removeIf(suggestion -> siblingLiterals.contains(suggestion.suggestion()));
            }
            int trimmed = builder2.getInput().length() - suggestionsResult.commandInput().length();
            int rawOffset = suggestionsResult.commandInput().cursor();
            SuggestionsBuilder suggestionsBuilder = builder2.createOffset(rawOffset + trimmed);
            for (TooltipSuggestion suggestion2 : suggestions) {
                try {
                    suggestionsBuilder.suggest(Integer.parseInt(suggestion2.suggestion()), suggestion2.tooltip());
                }
                catch (NumberFormatException e) {
                    suggestionsBuilder.suggest(suggestion2.suggestion(), suggestion2.tooltip());
                }
            }
            return suggestionsBuilder.build();
        });
    }
}

