/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestion;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Material;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MaterialParser<C>
implements ArgumentParser<C, Material>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Material> materialParser() {
        return ParserDescriptor.of(new MaterialParser<C>(), Material.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, Material> materialComponent() {
        return CommandComponent.builder().parser(MaterialParser.materialParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Material> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input2 = commandInput.readString();
        try {
            Material material = Material.valueOf((String)input2.toUpperCase(Locale.ROOT));
            return ArgumentParseResult.success(material);
        }
        catch (IllegalArgumentException exception) {
            return ArgumentParseResult.failure(new MaterialParseException(input2, commandContext));
        }
    }

    @Override
    public @NonNull Iterable<@NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        return Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).map(Suggestion::suggestion).collect(Collectors.toList());
    }

    public static final class MaterialParseException
    extends ParserException {
        private final String input;

        public MaterialParseException(@NonNull String input2, @NonNull CommandContext<?> context) {
            super(MaterialParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_MATERIAL, CaptionVariable.of("input", input2));
            this.input = input2;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

