/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCommandContextKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class OfflinePlayerParser<C>
implements ArgumentParser<C, OfflinePlayer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, OfflinePlayer> offlinePlayerParser() {
        return ParserDescriptor.of(new OfflinePlayerParser<C>(), OfflinePlayer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, OfflinePlayer> offlinePlayerComponent() {
        return CommandComponent.builder().parser(OfflinePlayerParser.offlinePlayerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<OfflinePlayer> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        OfflinePlayer player;
        String input2 = commandInput.readString();
        if (input2.length() > 16) {
            return ArgumentParseResult.failure(new OfflinePlayerParseException(input2, commandContext));
        }
        try {
            player = Bukkit.getOfflinePlayer((String)input2);
        }
        catch (Exception e) {
            return ArgumentParseResult.failure(new OfflinePlayerParseException(input2, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        CommandSender bukkit = commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
        return Bukkit.getOnlinePlayers().stream().filter(player -> !(bukkit instanceof Player) || ((Player)bukkit).canSee(player)).map(OfflinePlayer::getName).collect(Collectors.toList());
    }

    public static final class OfflinePlayerParseException
    extends ParserException {
        private final String input;

        public OfflinePlayerParseException(@NonNull String input2, @NonNull CommandContext<?> context) {
            super(OfflinePlayerParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_OFFLINEPLAYER, CaptionVariable.of("input", input2));
            this.input = input2;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

