/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.minecraft.extras;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;

final class Pagination<T> {
    private final BiFunction<Integer, Integer, List<Component>> headerRenderer;
    private final BiFunction<T, Boolean, Component> rowRenderer;
    private final BiFunction<Integer, Integer, Component> footerRenderer;
    private final BiFunction<Integer, Integer, Component> outOfRangeRenderer;

    Pagination(@NonNull BiFunction<Integer, Integer, List<Component>> headerRenderer, @NonNull BiFunction<T, Boolean, Component> rowRenderer, @NonNull BiFunction<Integer, Integer, Component> footerRenderer, @NonNull BiFunction<Integer, Integer, Component> outOfRangeRenderer) {
        this.headerRenderer = headerRenderer;
        this.rowRenderer = rowRenderer;
        this.footerRenderer = footerRenderer;
        this.outOfRangeRenderer = outOfRangeRenderer;
    }

    @NonNull List<Component> render(@NonNull List<T> content2, int page, int itemsPerPage) {
        int pages = (int)Math.ceil((double)content2.size() / ((double)itemsPerPage * 1.0));
        if (page < 1 || page > pages) {
            return Collections.singletonList(this.outOfRangeRenderer.apply(page, pages));
        }
        ArrayList<Component> renderedContent = new ArrayList<Component>((Collection)this.headerRenderer.apply(page, pages));
        int start2 = itemsPerPage * (page - 1);
        int maxIndex = start2 + itemsPerPage;
        for (int index = start2; index < maxIndex && index <= content2.size() - 1; ++index) {
            renderedContent.add(this.rowRenderer.apply(content2.get(index), index == maxIndex - 1));
        }
        renderedContent.add(this.footerRenderer.apply(page, pages));
        return Collections.unmodifiableList(renderedContent);
    }
}

