/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.minecraft.extras.caption;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.Caption;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.minecraft.extras.caption.RichVariable;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL)
final class MiniMessageComponentCaptionFormatter<C>
implements ComponentCaptionFormatter<C> {
    private final MiniMessage miniMessage;
    private final List<TagResolver> extraResolvers;

    MiniMessageComponentCaptionFormatter(@NonNull MiniMessage miniMessage, @NonNull List<TagResolver> extraResolvers) {
        this.miniMessage = miniMessage;
        this.extraResolvers = extraResolvers;
    }

    @Override
    public @NonNull Component formatCaption(@NonNull Caption captionKey, @NonNull C recipient, @NonNull String caption, @NonNull List<@NonNull CaptionVariable> variables) {
        TagResolver.Builder builder2 = TagResolver.builder();
        builder2.resolvers(this.extraResolvers);
        for (CaptionVariable variable : variables) {
            String key2 = variable.key();
            if (variable instanceof RichVariable) {
                builder2.resolver((TagResolver)Placeholder.component((String)key2, (ComponentLike)((RichVariable)variable).component()));
                continue;
            }
            builder2.resolver((TagResolver)Placeholder.parsed((String)key2, (String)variable.value()));
        }
        return this.miniMessage.deserialize(caption, builder2.build());
    }
}

