/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.minecraft.extras.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.StandardCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserContributor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserRegistry;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.type.tuple.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TextColorParser<C>
implements ArgumentParser<C, TextColor>,
BlockingSuggestionProvider.Strings<C> {
    private static final Pattern LEGACY_PREDICATE = Pattern.compile("&[0-9a-fA-F]");
    private static final Pattern HEX_PREDICATE = Pattern.compile("#?([a-fA-F0-9]{1,6})");
    private static final Collection<Pair<Character, NamedTextColor>> COLORS = Arrays.asList(Pair.of(Character.valueOf('0'), NamedTextColor.BLACK), Pair.of(Character.valueOf('1'), NamedTextColor.DARK_BLUE), Pair.of(Character.valueOf('2'), NamedTextColor.DARK_GREEN), Pair.of(Character.valueOf('3'), NamedTextColor.DARK_AQUA), Pair.of(Character.valueOf('4'), NamedTextColor.DARK_RED), Pair.of(Character.valueOf('5'), NamedTextColor.DARK_PURPLE), Pair.of(Character.valueOf('6'), NamedTextColor.GOLD), Pair.of(Character.valueOf('7'), NamedTextColor.GRAY), Pair.of(Character.valueOf('8'), NamedTextColor.DARK_GRAY), Pair.of(Character.valueOf('9'), NamedTextColor.BLUE), Pair.of(Character.valueOf('a'), NamedTextColor.GREEN), Pair.of(Character.valueOf('b'), NamedTextColor.AQUA), Pair.of(Character.valueOf('c'), NamedTextColor.RED), Pair.of(Character.valueOf('d'), NamedTextColor.LIGHT_PURPLE), Pair.of(Character.valueOf('e'), NamedTextColor.YELLOW), Pair.of(Character.valueOf('f'), NamedTextColor.WHITE));

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, TextColor> textColorParser() {
        return ParserDescriptor.of(new TextColorParser<C>(), TextColor.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, TextColor> textColorComponent() {
        return CommandComponent.builder().parser(TextColorParser.textColorParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull TextColor> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input2 = commandInput.peekString();
        if (LEGACY_PREDICATE.matcher(input2).matches()) {
            commandInput.moveCursor(1);
            char code = Character.toLowerCase(commandInput.read());
            for (Pair<Character, NamedTextColor> pair : COLORS) {
                if (pair.first().charValue() != code) continue;
                return ArgumentParseResult.success((TextColor)pair.second());
            }
            commandInput.moveCursor(-2);
        }
        for (Pair<Character, NamedTextColor> pair : COLORS) {
            if (!pair.second().toString().equalsIgnoreCase(commandInput.peekString())) continue;
            commandInput.readString();
            return ArgumentParseResult.success((TextColor)pair.second());
        }
        if (HEX_PREDICATE.matcher(commandInput.peekString()).matches()) {
            if (commandInput.peek() == '#') {
                commandInput.moveCursor(1);
            }
            return ArgumentParseResult.success(TextColor.color((int)commandInput.readInteger(16)));
        }
        return ArgumentParseResult.failure(new TextColorParseException(commandContext, input2));
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        LinkedList<String> suggestions = new LinkedList<String>();
        String token = input2.readString();
        String tokenLower = token.toLowerCase(Locale.ROOT);
        boolean matchedName = false;
        for (String name : NamedTextColor.NAMES.keys()) {
            if (name.contains(tokenLower)) {
                matchedName = true;
            }
            suggestions.add(name);
        }
        if (!matchedName && !token.isEmpty() && (token.equals("#") || HEX_PREDICATE.matcher(token).matches() && token.length() < (token.startsWith("#") ? 7 : 6))) {
            char c;
            for (c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
                suggestions.add(String.format("%s%c", token, Character.valueOf(c)));
            }
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                suggestions.add(String.format("%s%c", token, Character.valueOf(c)));
            }
        }
        return suggestions;
    }

    private static final class TextColorParseException
    extends ParserException {
        private TextColorParseException(@NonNull CommandContext<?> commandContext, @NonNull String input2) {
            super(TextColorParser.class, commandContext, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_COLOR, CaptionVariable.of("input", input2));
        }
    }

    @API(status=API.Status.INTERNAL)
    public static final class Contributor
    implements ParserContributor {
        @Override
        public <C> void contribute(ParserRegistry<C> registry) {
            try {
                registry.registerParser(TextColorParser.textColorParser());
            }
            catch (Exception | LinkageError throwable) {
                // empty catch block
            }
        }
    }
}

