/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.WorldParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestion;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class KeyedWorldParser<C>
implements ArgumentParser<C, World>,
SuggestionProvider<C> {
    private final ArgumentParser<C, World> parser;

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, World> keyedWorldParser() {
        return ParserDescriptor.of(new KeyedWorldParser<C>(), World.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, World> keyedWorldComponent() {
        return CommandComponent.builder().parser(KeyedWorldParser.keyedWorldParser());
    }

    public KeyedWorldParser() {
        Class<World> keyed = CraftBukkitReflection.findClass("org.bukkit.Keyed");
        this.parser = keyed != null && keyed.isAssignableFrom(World.class) ? null : new WorldParser();
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull World> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        if (this.parser != null) {
            return this.parser.parse(commandContext, commandInput);
        }
        String input2 = commandInput.readString();
        NamespacedKey key2 = NamespacedKey.fromString((String)input2);
        if (key2 == null) {
            return ArgumentParseResult.failure(new WorldParser.WorldParseException(input2, commandContext));
        }
        World world = Bukkit.getWorld((NamespacedKey)key2);
        if (world == null) {
            return ArgumentParseResult.failure(new WorldParser.WorldParseException(input2, commandContext));
        }
        return ArgumentParseResult.success(world);
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        if (this.parser != null) {
            return this.parser.suggestionProvider().suggestionsFuture(commandContext, input2);
        }
        List worlds = Bukkit.getWorlds();
        ArrayList<Suggestion> completions = new ArrayList<Suggestion>(worlds.size() * 2);
        for (World world : worlds) {
            NamespacedKey key2 = world.getKey();
            if (input2.hasRemainingInput() && key2.getNamespace().equals("minecraft")) {
                completions.add(Suggestion.suggestion(key2.getKey()));
            }
            completions.add(Suggestion.suggestion(key2.getNamespace() + ':' + key2.getKey()));
        }
        return CompletableFuture.completedFuture(completions);
    }
}

