/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.suggestion;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitPluginRegistrationHandler;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.internal.BukkitHelper;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.LegacyPaperCommandManager;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.suggestion.SuggestionListener;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestion;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestions;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.util.StringUtils;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.checkerframework.checker.nullness.qual.NonNull;

class AsyncCommandSuggestionListener<C>
implements SuggestionListener<C> {
    private final LegacyPaperCommandManager<C> paperCommandManager;

    AsyncCommandSuggestionListener(@NonNull LegacyPaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
    }

    @EventHandler
    void onTabCompletion(@NonNull AsyncTabCompleteEvent event) {
        String commandLabel;
        String strippedBuffer;
        String string = strippedBuffer = event.getBuffer().startsWith("/") ? event.getBuffer().substring(1) : event.getBuffer();
        if (strippedBuffer.trim().isEmpty()) {
            return;
        }
        BukkitPluginRegistrationHandler bukkitPluginRegistrationHandler = (BukkitPluginRegistrationHandler)this.paperCommandManager.commandRegistrationHandler();
        if (!bukkitPluginRegistrationHandler.isRecognized(commandLabel = strippedBuffer.split(" ")[0])) {
            return;
        }
        String input2 = event.getBuffer();
        if (input2.charAt(0) == '/') {
            input2 = input2.substring(1);
        }
        this.setSuggestions(event, this.paperCommandManager.senderMapper().map(event.getSender()), BukkitHelper.stripNamespace(this.paperCommandManager, input2));
        event.setHandled(true);
    }

    protected Suggestions<C, ?> querySuggestions(@NonNull C commandSender, @NonNull String input2) {
        return this.paperCommandManager.suggestionFactory().suggestImmediately(commandSender, input2);
    }

    protected void setSuggestions(@NonNull AsyncTabCompleteEvent event, @NonNull C commandSender, @NonNull String input2) {
        Suggestions suggestions = this.querySuggestions(commandSender, input2);
        event.setCompletions(suggestions.list().stream().map(Suggestion::suggestion).map(suggestion -> StringUtils.trimBeforeLastSpace(suggestion, suggestions.commandInput())).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

