/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.Command;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.CommandExecutionHandler;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.postprocessor.CommandPostprocessor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.key.CloudKey;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.cache.CloudCache;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation.ConfirmationConfiguration;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation.ConfirmationContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation.ConfirmationExecutionHandler;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation.ConfirmationPostprocessor;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE, since="1.0.0")
public final class ConfirmationManager<C>
implements Command.Builder.Applicable<C> {
    public static final CloudKey<Boolean> META_CONFIRMATION_REQUIRED = CloudKey.of("cloud:require_confirmation", Boolean.class);
    private final CloudCache<C, ConfirmationContext<C>> cache;
    private final ConfirmationConfiguration<C> configuration;

    public static <C> @NonNull ConfirmationManager<C> confirmationManager(@NonNull ConfirmationConfiguration<C> configuration) {
        return new ConfirmationManager<C>(Objects.requireNonNull(configuration, "configuration"));
    }

    public static <C> @NonNull ConfirmationManager<C> confirmationManager(@NonNull Function< @NonNull ImmutableConfirmationConfiguration.CacheBuildStage<C>,  @NonNull ImmutableConfirmationConfiguration.BuildFinal<C>> configuration) {
        return ConfirmationManager.confirmationManager(configuration.apply(ConfirmationConfiguration.builder()).build());
    }

    private ConfirmationManager(@NonNull ConfirmationConfiguration<C> configuration) {
        this.cache = Objects.requireNonNull(configuration.cache(), "cache");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public @NonNull ConfirmationConfiguration<C> configuration() {
        return this.configuration;
    }

    @Override
    public  @NonNull Command.Builder<C> applyToCommandBuilder( @NonNull Command.Builder<C> builder2) {
        return builder2.meta(META_CONFIRMATION_REQUIRED, true);
    }

    public @NonNull CommandExecutionHandler<C> createExecutionHandler() {
        return new ConfirmationExecutionHandler(this);
    }

    public @NonNull CommandPostprocessor<C> createPostprocessor() {
        return new ConfirmationPostprocessor(this);
    }

    public @NonNull Optional<ConfirmationContext<C>> popPending(@NonNull C sender2) {
        Duration age;
        Objects.requireNonNull(sender2, "sender");
        ConfirmationContext<C> context = this.cache.popIfPresent(sender2);
        if (context == null) {
            return Optional.empty();
        }
        Duration expiration = this.configuration.expiration();
        if (expiration != null && (age = Duration.between(context.creationTime(), Instant.now())).compareTo(expiration) > 0) {
            return Optional.empty();
        }
        return Optional.of(context);
    }

    void addPending(@NonNull C sender2, @NonNull ConfirmationContext<C> context) {
        Objects.requireNonNull(sender2, "sender");
        Objects.requireNonNull(context, "context");
        this.cache.put(sender2, context);
    }
}

