/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.internal.ThemeString;
import com.github.ajalt.mordant.internal.ThemeStyle;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.rendering.WidthRangeKt;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB/\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/ajalt/mordant/widgets/OrderedList;", "Lcom/github/ajalt/mordant/rendering/Widget;", "listEntries", "", "numberStyle", "Lcom/github/ajalt/mordant/internal/ThemeStyle;", "numberSeparator", "Lcom/github/ajalt/mordant/internal/ThemeString;", "<init>", "(Ljava/util/List;Lcom/github/ajalt/mordant/internal/ThemeStyle;Lcom/github/ajalt/mordant/internal/ThemeString;)V", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "", "(Ljava/util/List;Lcom/github/ajalt/mordant/rendering/TextStyle;Ljava/lang/String;)V", "sep", "Lcom/github/ajalt/mordant/rendering/Line;", "t", "Lcom/github/ajalt/mordant/rendering/Theme;", "continuationPadding", "Lcom/github/ajalt/mordant/rendering/Span;", "i", "", "sepWidth", "bulletWidth", "maxBulletWidth", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "mordant"})
@SourceDebugExtension(value={"SMAP\nOrderedList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedList.kt\ncom/github/ajalt/mordant/widgets/OrderedList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class OrderedList
implements Widget {
    @NotNull
    private final List<Widget> listEntries;
    @NotNull
    private final ThemeStyle numberStyle;
    @NotNull
    private final ThemeString numberSeparator;
    private final int maxBulletWidth;

    private OrderedList(List<? extends Widget> listEntries, ThemeStyle numberStyle, ThemeString numberSeparator) {
        this.listEntries = listEntries;
        this.numberStyle = numberStyle;
        this.numberSeparator = numberSeparator;
        this.maxBulletWidth = this.bulletWidth(this.listEntries.size(), LinesKt.getLineWidth(this.sep(Theme.Companion.getDefault())));
    }

    public OrderedList(@NotNull List<? extends Widget> listEntries, @Nullable TextStyle numberStyle, @Nullable String numberSeparator) {
        Intrinsics.checkNotNullParameter(listEntries, "listEntries");
        this(listEntries, ThemeStyle.Companion.of$default(ThemeStyle.Companion, "list.number", numberStyle, null, 4, null), ThemeString.Companion.of$default(ThemeString.Companion, "list.number.separator", numberSeparator, null, 4, null));
    }

    public /* synthetic */ OrderedList(List list, TextStyle textStyle, String string, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            textStyle = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        this((List<? extends Widget>)list, textStyle, string);
    }

    private final Line sep(Theme t2) {
        String text2 = this.numberSeparator.get(t2);
        if (!(!StringsKt.contains$default((CharSequence)text2, "\n", false, 2, null))) {
            boolean bl = false;
            String string = "number separator cannot contain newlines";
            throw new IllegalArgumentException(string.toString());
        }
        Line line = CollectionsKt.firstOrNull(ParsingKt.parseText(text2, this.numberStyle.get(t2)).getLines());
        if (line == null) {
            line = ConstantsKt.getEMPTY_LINE();
        }
        return line;
    }

    private final List<Span> continuationPadding(int i2, int sepWidth) {
        int n = this.bulletWidth(i2, sepWidth);
        return CollectionsKt.listOf(Span.Companion.space$default(Span.Companion, n, null, 2, null));
    }

    private final int bulletWidth(int i2, int sepWidth) {
        return (int)Math.log10(i2 + 1) + 1 + 2 + sepWidth;
    }

    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t2, int width) {
        Intrinsics.checkNotNullParameter(t2, "t");
        return WidthRangeKt.maxWidthRange((Iterable<? extends Widget>)this.listEntries, t2, width, this.maxBulletWidth);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t2, int width) {
        Intrinsics.checkNotNullParameter(t2, "t");
        int contentWidth = width - this.maxBulletWidth;
        List lines = new ArrayList();
        TextStyle style = this.numberStyle.get(t2);
        Line sep = this.sep(t2.getTheme());
        int sepWidth = LinesKt.getLineWidth(sep);
        Iterator iterator2 = ((Iterable)this.listEntries).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            Widget entry = (Widget)iterator2.next();
            Object object = new Object[]{ConstantsKt.getSINGLE_SPACE(), Span.Companion.word(String.valueOf(i2 + 1), style), sep, ConstantsKt.getSINGLE_SPACE()};
            Line bullet = LinesKt.flatLine((Object[])object);
            object = ((Iterable)entry.render(t2, contentWidth).getLines()).iterator();
            int n2 = 0;
            while (object.hasNext()) {
                int j = n2++;
                Line line = (Line)object.next();
                List<Span> start2 = j == 0 ? (List<Span>)bullet : this.continuationPadding(i2, sepWidth);
                ((Collection)lines).add(new Line(CollectionsKt.plus((Collection)start2, (Iterable)line)));
            }
        }
        return new Lines(lines);
    }
}

