/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\u001a\u001b\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\u0006\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0005\u001a\u001b\u0010\u0007\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0007\u0010\u0005\u001a\u001b\u0010\b\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\b\u0010\u0005\u001a\u001b\u0010\t\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001b\u0010\u000b\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u000b\u0010\n\u001a7\u0010\u0013\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a'\u0010\r\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\r\u0010\u0018\"\u0014\u0010\u0019\u001a\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\"\u0014\u0010\u001b\u001a\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001a\"\u001a\u0010\u001c\u001a\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001a\u001a\u0004\b\u001d\u0010\u001e\"\u001a\u0010\u001f\u001a\u00020\u00008\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b \u0010\u001e\u00a8\u0006!"}, d2={"", "Lio/ktor/network/tls/CipherSuite;", "suite", "Ljavax/crypto/spec/SecretKeySpec;", "clientMacKey", "([BLio/ktor/network/tls/CipherSuite;)Ljavax/crypto/spec/SecretKeySpec;", "serverMacKey", "serverKey", "clientKey", "clientIV", "([BLio/ktor/network/tls/CipherSuite;)[B", "serverIV", "Ljavax/crypto/SecretKey;", "masterSecret", "seed", "", "keySize", "macSize", "ivSize", "keyMaterial", "(Ljavax/crypto/SecretKey;[BIII)[B", "preMasterSecret", "clientRandom", "serverRandom", "(Ljavax/crypto/SecretKey;[B[B)Ljavax/crypto/spec/SecretKeySpec;", "MASTER_SECRET_LABEL", "[B", "KEY_EXPANSION_LABEL", "CLIENT_FINISHED_LABEL", "getCLIENT_FINISHED_LABEL", "()[B", "SERVER_FINISHED_LABEL", "getSERVER_FINISHED_LABEL", "ktor-network-tls"})
public final class KeysKt {
    @NotNull
    private static final byte[] MASTER_SECRET_LABEL;
    @NotNull
    private static final byte[] KEY_EXPANSION_LABEL;
    @NotNull
    private static final byte[] CLIENT_FINISHED_LABEL;
    @NotNull
    private static final byte[] SERVER_FINISHED_LABEL;

    @NotNull
    public static final byte[] getCLIENT_FINISHED_LABEL() {
        return CLIENT_FINISHED_LABEL;
    }

    @NotNull
    public static final byte[] getSERVER_FINISHED_LABEL() {
        return SERVER_FINISHED_LABEL;
    }

    @NotNull
    public static final SecretKeySpec clientMacKey(@NotNull byte[] $this$clientMacKey, @NotNull CipherSuite suite) {
        Intrinsics.checkNotNullParameter($this$clientMacKey, "<this>");
        Intrinsics.checkNotNullParameter(suite, "suite");
        return new SecretKeySpec($this$clientMacKey, 0, suite.getMacStrengthInBytes(), suite.getHash().getMacName());
    }

    @NotNull
    public static final SecretKeySpec serverMacKey(@NotNull byte[] $this$serverMacKey, @NotNull CipherSuite suite) {
        Intrinsics.checkNotNullParameter($this$serverMacKey, "<this>");
        Intrinsics.checkNotNullParameter(suite, "suite");
        return new SecretKeySpec($this$serverMacKey, suite.getMacStrengthInBytes(), suite.getMacStrengthInBytes(), suite.getHash().getMacName());
    }

    @NotNull
    public static final SecretKeySpec serverKey(@NotNull byte[] $this$serverKey, @NotNull CipherSuite suite) {
        Intrinsics.checkNotNullParameter($this$serverKey, "<this>");
        Intrinsics.checkNotNullParameter(suite, "suite");
        return new SecretKeySpec($this$serverKey, 2 * suite.getMacStrengthInBytes() + suite.getKeyStrengthInBytes(), suite.getKeyStrengthInBytes(), StringsKt.substringBefore$default(suite.getJdkCipherName(), "/", null, 2, null));
    }

    @NotNull
    public static final SecretKeySpec clientKey(@NotNull byte[] $this$clientKey, @NotNull CipherSuite suite) {
        Intrinsics.checkNotNullParameter($this$clientKey, "<this>");
        Intrinsics.checkNotNullParameter(suite, "suite");
        return new SecretKeySpec($this$clientKey, 2 * suite.getMacStrengthInBytes(), suite.getKeyStrengthInBytes(), StringsKt.substringBefore$default(suite.getJdkCipherName(), "/", null, 2, null));
    }

    @NotNull
    public static final byte[] clientIV(@NotNull byte[] $this$clientIV, @NotNull CipherSuite suite) {
        Intrinsics.checkNotNullParameter($this$clientIV, "<this>");
        Intrinsics.checkNotNullParameter(suite, "suite");
        byte[] byArray = $this$clientIV;
        int n = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes();
        int n2 = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes() + suite.getFixedIvLength();
        return ArraysKt.copyOfRange(byArray, n, n2);
    }

    @NotNull
    public static final byte[] serverIV(@NotNull byte[] $this$serverIV, @NotNull CipherSuite suite) {
        Intrinsics.checkNotNullParameter($this$serverIV, "<this>");
        Intrinsics.checkNotNullParameter(suite, "suite");
        byte[] byArray = $this$serverIV;
        int n = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes() + suite.getFixedIvLength();
        int n2 = 2 * suite.getMacStrengthInBytes() + 2 * suite.getKeyStrengthInBytes() + 2 * suite.getFixedIvLength();
        return ArraysKt.copyOfRange(byArray, n, n2);
    }

    @NotNull
    public static final byte[] keyMaterial(@NotNull SecretKey masterSecret, @NotNull byte[] seed, int keySize, int macSize, int ivSize) {
        Intrinsics.checkNotNullParameter(masterSecret, "masterSecret");
        Intrinsics.checkNotNullParameter(seed, "seed");
        int materialSize = 2 * macSize + 2 * keySize + 2 * ivSize;
        return HashesKt.PRF(masterSecret, KEY_EXPANSION_LABEL, seed, materialSize);
    }

    @NotNull
    public static final SecretKeySpec masterSecret(@NotNull SecretKey preMasterSecret, @NotNull byte[] clientRandom, @NotNull byte[] serverRandom) {
        Intrinsics.checkNotNullParameter(preMasterSecret, "preMasterSecret");
        Intrinsics.checkNotNullParameter(clientRandom, "clientRandom");
        Intrinsics.checkNotNullParameter(serverRandom, "serverRandom");
        return new SecretKeySpec(HashesKt.PRF(preMasterSecret, MASTER_SECRET_LABEL, ArraysKt.plus(clientRandom, serverRandom), 48), preMasterSecret.getAlgorithm());
    }

    static {
        String string = "master secret";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        MASTER_SECRET_LABEL = byArray;
        string = "key expansion";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray2, "getBytes(...)");
        KEY_EXPANSION_LABEL = byArray2;
        string = "client finished";
        byte[] byArray3 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray3, "getBytes(...)");
        CLIENT_FINISHED_LABEL = byArray3;
        string = "server finished";
        byte[] byArray4 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray4, "getBytes(...)");
        SERVER_FINISHED_LABEL = byArray4;
    }
}

