/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions.serialization;

import io.ktor.server.sessions.SessionSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/sessions/serialization/KotlinxSessionSerializer;", "", "T", "Lio/ktor/server/sessions/SessionSerializer;", "Lkotlinx/serialization/StringFormat;", "format", "Lkotlinx/serialization/KSerializer;", "serializer", "<init>", "(Lkotlinx/serialization/StringFormat;Lkotlinx/serialization/KSerializer;)V", "session", "", "serialize", "(Ljava/lang/Object;)Ljava/lang/String;", "text", "deserialize", "(Ljava/lang/String;)Ljava/lang/Object;", "Lkotlinx/serialization/StringFormat;", "Lkotlinx/serialization/KSerializer;", "ktor-server-sessions"})
final class KotlinxSessionSerializer<T>
implements SessionSerializer<T> {
    @NotNull
    private final StringFormat format;
    @NotNull
    private final KSerializer<T> serializer;

    public KotlinxSessionSerializer(@NotNull StringFormat format, @NotNull KSerializer<T> serializer2) {
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        this.format = format;
        this.serializer = serializer2;
    }

    @Override
    @NotNull
    public String serialize(@NotNull T session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        return this.format.encodeToString((SerializationStrategy)this.serializer, session2);
    }

    @Override
    @NotNull
    public T deserialize(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        return this.format.decodeFromString((DeserializationStrategy)this.serializer, text2);
    }
}

