/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions.serialization;

import io.ktor.http.CodecsKt;
import io.ktor.http.HttpUrlEncodedKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.server.sessions.serialization.ListLikeDecoder;
import io.ktor.server.sessions.serialization.MapDecoder;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b#\u0010\u0012J\u0011\u0010%\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\n2\u0006\u0010'\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b(\u0010\fR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u0004008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00103\u001a\u00020\u00048\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b3\u0010,\u00a8\u00064"}, d2={"Lio/ktor/server/sessions/serialization/SessionsBackwardCompatibleDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "", "string", "<init>", "(Lkotlinx/serialization/modules/SerializersModule;Ljava/lang/String;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "decodeBoolean", "()Z", "", "decodeChar", "()C", "", "decodeDouble", "()D", "", "decodeFloat", "()F", "decodeInt", "()I", "", "decodeLong", "()J", "decodeString", "()Ljava/lang/String;", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "enumDescriptor", "decodeEnum", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "Ljava/lang/String;", "Lio/ktor/http/Parameters;", "parameters", "Lio/ktor/http/Parameters;", "", "parameterNames", "Ljava/util/Iterator;", "currentName", "ktor-server-sessions"})
public final class SessionsBackwardCompatibleDecoder
extends AbstractDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final String string;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final Iterator<String> parameterNames;
    private String currentName;

    public SessionsBackwardCompatibleDecoder(@NotNull SerializersModule serializersModule, @NotNull String string) {
        Intrinsics.checkNotNullParameter(serializersModule, "serializersModule");
        Intrinsics.checkNotNullParameter(string, "string");
        this.serializersModule = serializersModule;
        this.string = string;
        this.parameters = QueryKt.parseQueryString$default(this.string, 0, 0, true, 6, null);
        this.parameterNames = this.parameters.names().iterator();
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!this.parameterNames.hasNext()) {
            return -1;
        }
        this.currentName = this.parameterNames.next();
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        return descriptor2.getElementIndex(string);
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.currentName == null) {
            return new SessionsBackwardCompatibleDecoder(this.getSerializersModule(), this.string);
        }
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            String string = this.currentName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("currentName");
                string = null;
            }
            String string2 = this.parameters.get(string);
            Intrinsics.checkNotNull(string2);
            String value = CodecsKt.decodeURLQueryComponent$default(StringsKt.drop(string2, 3), 0, 0, false, null, 15, null);
            return new ListLikeDecoder(this.getSerializersModule(), value);
        }
        if (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            String string = this.currentName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("currentName");
                string = null;
            }
            String string3 = this.parameters.get(string);
            Intrinsics.checkNotNull(string3);
            String encoded = CodecsKt.decodeURLQueryComponent$default(StringsKt.drop(string3, 2), 0, 0, false, null, 15, null);
            Parameters decoded = QueryKt.parseQueryString$default(encoded, 0, 0, true, 6, null);
            return new MapDecoder(this.getSerializersModule(), HttpUrlEncodedKt.formUrlEncode(decoded));
        }
        if (Intrinsics.areEqual(serialKind, StructureKind.CLASS.INSTANCE)) {
            String string = this.currentName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException("currentName");
                string = null;
            }
            String string4 = this.parameters.get(string);
            Intrinsics.checkNotNull(string4);
            String value = CodecsKt.decodeURLQueryComponent$default(StringsKt.drop(string4, 2), 0, 0, false, null, 15, null);
            return new SessionsBackwardCompatibleDecoder(this.getSerializersModule(), value);
        }
        throw new IllegalArgumentException("Unsupported kind: " + descriptor2.getKind());
    }

    @Override
    public boolean decodeBoolean() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return Intrinsics.areEqual(string2, "#bot");
    }

    @Override
    public char decodeChar() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return string2.charAt(3);
    }

    @Override
    public double decodeDouble() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return Double.parseDouble(StringsKt.drop(string2, 2));
    }

    @Override
    public float decodeFloat() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return Float.parseFloat(StringsKt.drop(string2, 2));
    }

    @Override
    public int decodeInt() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return Integer.parseInt(StringsKt.drop(string2, 2));
    }

    @Override
    public long decodeLong() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return Long.parseLong(StringsKt.drop(string2, 2));
    }

    @Override
    @NotNull
    public String decodeString() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return StringsKt.drop(string2, 2);
    }

    @Override
    public boolean decodeNotNullMark() {
        String string = this.currentName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentName");
            string = null;
        }
        String string2 = this.parameters.get(string);
        Intrinsics.checkNotNull(string2);
        return !Intrinsics.areEqual(string2, "#n");
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return null;
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        String enumName = this.decodeString();
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new IllegalStateException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

