/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.sign.shared.repository.location;

import app.simplecloud.plugin.sign.shared.LocationMapper;
import app.simplecloud.plugin.sign.shared.config.location.LocationsConfig;
import app.simplecloud.plugin.sign.shared.config.location.SignLocation;
import app.simplecloud.plugin.sign.shared.repository.base.YamlDirectoryRepository;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0004J\u0013\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lapp/simplecloud/plugin/sign/shared/repository/location/LocationsRepository;", "T", "", "Lapp/simplecloud/plugin/sign/shared/repository/base/YamlDirectoryRepository;", "", "Lapp/simplecloud/plugin/sign/shared/config/location/LocationsConfig;", "directoryPath", "Ljava/nio/file/Path;", "locationMapper", "Lapp/simplecloud/plugin/sign/shared/LocationMapper;", "<init>", "(Ljava/nio/file/Path;Lapp/simplecloud/plugin/sign/shared/LocationMapper;)V", "save", "", "element", "getFileName", "groupName", "find", "findByLocation", "location", "(Ljava/lang/Object;)Lapp/simplecloud/plugin/sign/shared/config/location/LocationsConfig;", "saveLocation", "group", "(Ljava/lang/String;Ljava/lang/Object;)V", "removeLocationGroup", "removeLocation", "(Ljava/lang/Object;)V", "sign-shared"})
@SourceDebugExtension(value={"SMAP\nLocationsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationsRepository.kt\napp/simplecloud/plugin/sign/shared/repository/location/LocationsRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1#2:54\n1755#3,3:55\n*S KotlinDebug\n*F\n+ 1 LocationsRepository.kt\napp/simplecloud/plugin/sign/shared/repository/location/LocationsRepository\n*L\n28#1:55,3\n*E\n"})
public final class LocationsRepository<T>
extends YamlDirectoryRepository<String, LocationsConfig> {
    @NotNull
    private final Path directoryPath;
    @NotNull
    private final LocationMapper<T> locationMapper;

    public LocationsRepository(@NotNull Path directoryPath, @NotNull LocationMapper<T> locationMapper) {
        Intrinsics.checkNotNullParameter(directoryPath, "directoryPath");
        Intrinsics.checkNotNullParameter(locationMapper, "locationMapper");
        super(directoryPath, LocationsConfig.class, null, 4, null);
        this.directoryPath = directoryPath;
        this.locationMapper = locationMapper;
    }

    @Override
    public void save(@NotNull LocationsConfig element) {
        Intrinsics.checkNotNullParameter(element, "element");
        this.save(this.getFileName(element.getGroup()), element);
    }

    @Override
    @NotNull
    public String getFileName(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        return groupName + ".yml";
    }

    @Override
    @Nullable
    public LocationsConfig find(@NotNull String groupName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(groupName, "groupName");
            Iterable iterable = this.getEntities().values();
            for (Object t2 : iterable) {
                LocationsConfig it = (LocationsConfig)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getGroup(), groupName)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final LocationsConfig findByLocation(T location) {
        Object v1;
        block5: {
            Iterable iterable = this.getEntities().values();
            for (Object t2 : iterable) {
                boolean bl;
                block4: {
                    LocationsConfig it = (LocationsConfig)t2;
                    boolean bl2 = false;
                    Iterable $this$any$iv = it.getLocations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SignLocation it2 = (SignLocation)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it2, this.locationMapper.unmap(location))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = t2;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    public final void saveLocation(@NotNull String group, @NotNull T location) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(location, "location");
        LocationsConfig locationsConfig = this.find(group);
        if (locationsConfig == null) {
            locationsConfig = new LocationsConfig(group, null, 2, null);
        }
        LocationsConfig config2 = locationsConfig;
        SignLocation signLocation = this.locationMapper.unmap(location);
        this.save(LocationsConfig.copy$default(config2, null, CollectionsKt.plus((Collection)config2.getLocations(), signLocation), 1, null));
    }

    public final void removeLocationGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter(group, "group");
        Files.delete(this.directoryPath.resolve(this.getFileName(group)));
    }

    public final void removeLocation(@NotNull T location) {
        Intrinsics.checkNotNullParameter(location, "location");
        LocationsConfig locationsConfig = this.findByLocation(location);
        if (locationsConfig == null) {
            return;
        }
        LocationsConfig config2 = locationsConfig;
        SignLocation signLocation = this.locationMapper.unmap(location);
        this.save(LocationsConfig.copy$default(config2, null, CollectionsKt.minus((Iterable)config2.getLocations(), signLocation), 1, null));
    }
}

