/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.cache;

import app.simplecloud.relocate.google.common.annotations.GwtIncompatible;
import app.simplecloud.relocate.google.common.cache.AbstractCache;
import app.simplecloud.relocate.google.common.cache.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.cache.LoadingCache;
import app.simplecloud.relocate.google.common.collect.ImmutableMap;
import app.simplecloud.relocate.google.common.collect.Maps;
import app.simplecloud.relocate.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key2) {
        try {
            return this.get(key2);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys2) throws ExecutionException {
        LinkedHashMap result2 = Maps.newLinkedHashMap();
        for (K key2 : keys2) {
            if (result2.containsKey(key2)) continue;
            result2.put(key2, this.get(key2));
        }
        return ImmutableMap.copyOf(result2);
    }

    @Override
    public final V apply(K key2) {
        return this.getUnchecked(key2);
    }

    @Override
    public void refresh(K key2) {
        throw new UnsupportedOperationException();
    }
}

