/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class WorldParser<C>
implements ArgumentParser<C, World>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, World> worldParser() {
        return ParserDescriptor.of(new WorldParser<C>(), World.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, World> worldComponent() {
        return CommandComponent.builder().parser(WorldParser.worldParser());
    }

    @Override
    public @NonNull ArgumentParseResult<World> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input2 = commandInput.readString();
        World world = Bukkit.getWorld((String)input2);
        if (world == null) {
            return ArgumentParseResult.failure(new WorldParseException(input2, commandContext));
        }
        return ArgumentParseResult.success(world);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        return Bukkit.getWorlds().stream().map(World::getName).collect(Collectors.toList());
    }

    public static final class WorldParseException
    extends ParserException {
        private final String input;

        public WorldParseException(@NonNull String input2, @NonNull CommandContext<?> context) {
            super(WorldParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_WORLD, CaptionVariable.of("input", input2));
            this.input = input2;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

