/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.location;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.location.LocationCoordinate;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser.location.LocationCoordinateType;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.standard.DoubleParser;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LocationCoordinateParser<C>
implements ArgumentParser<C, LocationCoordinate> {
    @Override
    public @NonNull ArgumentParseResult<@NonNull LocationCoordinate> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        double coordinate;
        LocationCoordinateType locationCoordinateType;
        String input2 = commandInput.skipWhitespace().peekString();
        if (commandInput.peek() == '^') {
            locationCoordinateType = LocationCoordinateType.LOCAL;
            commandInput.moveCursor(1);
        } else if (commandInput.peek() == '~') {
            locationCoordinateType = LocationCoordinateType.RELATIVE;
            commandInput.moveCursor(1);
        } else {
            locationCoordinateType = LocationCoordinateType.ABSOLUTE;
        }
        try {
            boolean empty = commandInput.peekString().isEmpty() || commandInput.peek() == ' ';
            double d = coordinate = empty ? 0.0 : commandInput.readDouble();
            if (commandInput.hasRemainingInput()) {
                commandInput.skipWhitespace();
            }
        }
        catch (Exception e) {
            return ArgumentParseResult.failure(new DoubleParser.DoubleParseException(input2, new DoubleParser(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), commandContext));
        }
        return ArgumentParseResult.success(LocationCoordinate.of(locationCoordinateType, coordinate));
    }
}

