/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.key;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.key.CloudKey;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.key.CloudKeyHolder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public interface CloudKeyContainer {
    public <V> @NonNull Optional<V> optional(@NonNull CloudKey<V> var1);

    public <V> @NonNull Optional<V> optional(@NonNull String var1);

    default public <V> @NonNull Optional<V> optional(@NonNull CloudKeyHolder<V> keyHolder) {
        return this.optional(keyHolder.key());
    }

    default public <V> V getOrDefault(@NonNull CloudKey<@NonNull V> key2, V defaultValue) {
        return this.optional(key2).orElse(defaultValue);
    }

    default public <V> V getOrDefault(@NonNull String key2, V defaultValue) {
        return this.optional(key2).orElse(defaultValue);
    }

    default public <V> V getOrDefault(@NonNull CloudKeyHolder<@NonNull V> keyHolder, V defaultValue) {
        return this.getOrDefault(keyHolder.key(), defaultValue);
    }

    default public <V> V getOrSupplyDefault(@NonNull CloudKey<@NonNull V> key2, @NonNull Supplier<V> supplier) {
        return this.optional(key2).orElseGet(supplier);
    }

    default public <V> V getOrSupplyDefault(@NonNull String key2, @NonNull Supplier<V> supplier) {
        return this.optional(key2).orElseGet(supplier);
    }

    default public <V> V getOrSupplyDefault(@NonNull CloudKeyHolder<@NonNull V> keyHolder, @NonNull Supplier<V> supplier) {
        return this.optional(keyHolder).orElseGet(supplier);
    }

    default public <V> V get(@NonNull CloudKey<V> key2) {
        return this.optional(key2).orElseThrow(() -> new NullPointerException(String.format("There is no object in the registry identified by the key '%s'", key2.name())));
    }

    default public <V> V get(@NonNull String key2) {
        return (V)this.optional(key2).map(value -> value).orElseThrow(() -> new NullPointerException(String.format("There is no object in the registry identified by the key '%s'", key2)));
    }

    default public <V> V get(@NonNull CloudKeyHolder<V> keyHolder) {
        return this.get(keyHolder.key());
    }

    public boolean contains(@NonNull CloudKey<?> var1);

    default public boolean contains(@NonNull String key2) {
        return this.contains(CloudKey.of(key2));
    }

    default public boolean contains(@NonNull CloudKeyHolder<?> keyHolder) {
        return this.contains(keyHolder.key());
    }

    public @NonNull Map<CloudKey<?>, ? extends @NonNull Object> all();
}

