/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.HueColorKt;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\b\b\u0002\u0010\u0006\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0000H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J1\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lcom/github/ajalt/colormath/model/HSL;", "Lcom/github/ajalt/colormath/HueColor;", "h", "", "s", "l", "alpha", "<init>", "(FFFF)V", "", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getH", "()F", "getS", "getL", "getAlpha", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toHSV", "Lcom/github/ajalt/colormath/model/HSV;", "toHSL", "toArray", "", "clamp", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nHSL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSL.kt\ncom/github/ajalt/colormath/model/HSL\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,71:1\n112#2,12:72\n*S KotlinDebug\n*F\n+ 1 HSL.kt\ncom/github/ajalt/colormath/model/HSL\n*L\n69#1:72,12\n*E\n"})
public final class HSL
implements HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float h;
    private final float s;
    private final float l;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.polarComponentInfo("HSL", 0.0f, 1.0f);

    public HSL(float h2, float s2, float l, float alpha) {
        this.h = h2;
        this.s = s2;
        this.l = l;
        this.alpha = alpha;
    }

    public /* synthetic */ HSL(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    @Override
    public float getH() {
        return this.h;
    }

    public final float getS() {
        return this.s;
    }

    public final float getL() {
        return this.l;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public HSL(@NotNull Number h2, @NotNull Number s2, @NotNull Number l, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(h2, "h");
        Intrinsics.checkNotNullParameter(s2, "s");
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(h2.floatValue(), s2.floatValue(), l.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ HSL(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<HSL> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        if ((double)this.s < 1.0E-7) {
            return RGB.Companion.invoke(this.l, this.l, this.l, this.getAlpha());
        }
        double h2 = (double)InternalMathKt.normalizeDeg(HueColorKt.hueOr(this, 0)) / 30.0;
        double s2 = this.s;
        double l = this.l;
        return SRGB.INSTANCE.invoke(HSL.toSRGB$f(h2, s2, l, 0), HSL.toSRGB$f(h2, s2, l, 8), HSL.toSRGB$f(h2, s2, l, 4), this.getAlpha());
    }

    @Override
    @NotNull
    public HSV toHSV() {
        float s2 = this.s;
        float l = this.l;
        float smin = s2;
        float lmin = Math.max(l, 0.01f);
        float v = (l + (s2 *= (l *= (float)2) <= 1.0f ? l : (float)2 - l)) / (float)2;
        float sv = l == 0.0f ? (float)2 * (smin *= lmin <= 1.0f ? lmin : (float)2 - lmin) / (lmin + smin) : (float)2 * s2 / (l + s2);
        return new HSV(this.getH(), sv, v, this.getAlpha());
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.getH(), this.s, this.l, this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public HSL clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clampLeadingHue$iv;
        Color color2 = this;
        float f = this.getH();
        float f2 = this.s;
        float f3 = this.l;
        float alpha$iv = this.getAlpha();
        boolean $i$f$clampLeadingHue = false;
        List<ColorComponentInfo> list = $this$clampLeadingHue$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clampLeadingHue$iv;
                        return (HSL)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn(alpha$iv, 0.0f, 1.0f);
        float f6 = RangesKt.coerceIn((float)v3$iv, c3$iv.getMin(), c3$iv.getMax());
        float f7 = RangesKt.coerceIn((float)v2$iv, c2$iv.getMin(), c2$iv.getMax());
        void p0 = v1$iv % (float)360;
        boolean bl5 = false;
        color = this.copy((float)p0, (float)p1, (float)p2, (float)p3);
        return (HSL)color;
    }

    public final float component1() {
        return this.h;
    }

    public final float component2() {
        return this.s;
    }

    public final float component3() {
        return this.l;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final HSL copy(float h2, float s2, float l, float alpha) {
        return new HSL(h2, s2, l, alpha);
    }

    public static /* synthetic */ HSL copy$default(HSL hSL, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = hSL.h;
        }
        if ((n & 2) != 0) {
            f2 = hSL.s;
        }
        if ((n & 4) != 0) {
            f3 = hSL.l;
        }
        if ((n & 8) != 0) {
            f4 = hSL.alpha;
        }
        return hSL.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "HSL(h=" + this.h + ", s=" + this.s + ", l=" + this.l + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.h);
        result2 = result2 * 31 + Float.hashCode(this.s);
        result2 = result2 * 31 + Float.hashCode(this.l);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HSL)) {
            return false;
        }
        HSL hSL = (HSL)other;
        if (Float.compare(this.h, hSL.h) != 0) {
            return false;
        }
        if (Float.compare(this.s, hSL.s) != 0) {
            return false;
        }
        if (Float.compare(this.l, hSL.l) != 0) {
            return false;
        }
        return Float.compare(this.alpha, hSL.alpha) == 0;
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return HueColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return HueColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return HueColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return HueColor.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return HueColor.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return HueColor.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return HueColor.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return HueColor.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return HueColor.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return HueColor.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return HueColor.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return HueColor.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return HueColor.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return HueColor.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return HueColor.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return HueColor.DefaultImpls.toHPLuv(this);
    }

    private static final float toSRGB$f(double h2, double s2, double l, int n) {
        double k = ((double)n + h2) % 12.0;
        double a = s2 * Math.min(l, 1.0 - l);
        return (float)(l - a * RangesKt.coerceAtLeast(Math.min(k - (double)3, Math.min((double)9 - k, 1.0)), -1.0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/github/ajalt/colormath/model/HSL$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/HSL;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nHSL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSL.kt\ncom/github/ajalt/colormath/model/HSL$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n26#2:72\n15#2,13:73\n1#3:86\n*S KotlinDebug\n*F\n+ 1 HSL.kt\ncom/github/ajalt/colormath/model/HSL$Companion\n*L\n28#1:72\n28#1:73,13\n28#1:86\n*E\n"})
    public static final class Companion
    implements ColorSpace<HSL> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "HSL";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public HSL convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toHSL();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HSL create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 < fArray.length) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (HSL)((Color)new HSL(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

