/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.sign.shared;

import app.simplecloud.plugin.sign.shared.CloudSign;
import app.simplecloud.plugin.sign.shared.LocationMapper;
import app.simplecloud.plugin.sign.shared.SignManager;
import app.simplecloud.plugin.sign.shared.SignManagerKt;
import app.simplecloud.plugin.sign.shared.SignState;
import app.simplecloud.plugin.sign.shared.SignUpdater;
import app.simplecloud.plugin.sign.shared.cache.ServerCache;
import app.simplecloud.plugin.sign.shared.config.layout.LayoutConfig;
import app.simplecloud.plugin.sign.shared.config.location.LocationsConfig;
import app.simplecloud.plugin.sign.shared.config.location.SignLocation;
import app.simplecloud.plugin.sign.shared.config.matcher.MatcherConfigEntry;
import app.simplecloud.plugin.sign.shared.config.matcher.MatcherType;
import app.simplecloud.plugin.sign.shared.repository.base.LoadableRepository;
import app.simplecloud.plugin.sign.shared.repository.layout.LayoutRepository;
import app.simplecloud.plugin.sign.shared.repository.location.LocationsRepository;
import app.simplecloud.plugin.sign.shared.rule.RuleRegistry;
import app.simplecloud.plugin.sign.shared.rule.SignRule;
import app.simplecloud.plugin.sign.shared.rule.impl.RuleContext;
import app.simplecloud.plugin.sign.shared.rule.serialize.SignRuleSerializer;
import app.simplecloud.plugin.sign.shared.service.SignService;
import app.simplecloud.signs.plugin.relocate.controller.api.ControllerApi;
import app.simplecloud.signs.plugin.relocate.controller.shared.server.Server;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize.TypeSerializer;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize.TypeSerializerCollection;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\b\u0018\u0000 Z*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001ZB;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020&H\u0086@\u00a2\u0006\u0002\u0010(J\u001d\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010-J\u001d\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010/2\u0006\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020+02H\u0016J\u0018\u00105\u001a\n\u0012\u0004\u0012\u000203\u0018\u0001022\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u00106\u001a\u00020&2\u0006\u0010,\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020+H\u0016J\u0015\u0010:\u001a\u00028\u00002\u0006\u0010,\u001a\u000203H\u0016\u00a2\u0006\u0002\u0010;J\u0015\u0010<\u001a\u0002032\u0006\u0010,\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010=J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AJ*\u0010B\u001a\u0002092\u0018\u0010C\u001a\u0014\u0012\u0004\u0012\u00020E\u0012\n\u0012\b\u0012\u0004\u0012\u00020F020D2\u0006\u0010G\u001a\u00020+H\u0002J\b\u0010H\u001a\u00020&H\u0002J\b\u0010I\u001a\u00020&H\u0002J\u000e\u0010J\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010(J$\u0010J\u001a\u00020&2\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N02H\u0082@\u00a2\u0006\u0002\u0010OJ2\u0010P\u001a\u00020&2\u0006\u0010Q\u001a\u0002032\f\u0010R\u001a\b\u0012\u0004\u0012\u00020N0S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020N02H\u0082@\u00a2\u0006\u0002\u0010UJ\u001c\u0010V\u001a\u00020&2\f\u0010W\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0082@\u00a2\u0006\u0002\u0010XJ\u000e\u0010Y\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010(R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\n \u0014*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lapp/simplecloud/plugin/sign/shared/SignManager;", "T", "", "Lapp/simplecloud/plugin/sign/shared/service/SignService;", "controllerApi", "Lapp/simplecloud/signs/plugin/relocate/controller/api/ControllerApi$Coroutine;", "directoryPath", "Ljava/nio/file/Path;", "locationMapper", "Lapp/simplecloud/plugin/sign/shared/LocationMapper;", "ruleRegistry", "Lapp/simplecloud/plugin/sign/shared/rule/RuleRegistry;", "signUpdater", "Lapp/simplecloud/plugin/sign/shared/SignUpdater;", "<init>", "(Lapp/simplecloud/controller/api/ControllerApi$Coroutine;Ljava/nio/file/Path;Lapp/simplecloud/plugin/sign/shared/LocationMapper;Lapp/simplecloud/plugin/sign/shared/rule/RuleRegistry;Lapp/simplecloud/plugin/sign/shared/SignUpdater;)V", "getControllerApi", "()Lapp/simplecloud/controller/api/ControllerApi$Coroutine;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "state", "Lapp/simplecloud/plugin/sign/shared/SignState;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "updateJob", "Lkotlinx/coroutines/Job;", "locationsRepository", "Lapp/simplecloud/plugin/sign/shared/repository/location/LocationsRepository;", "layoutRepository", "Lapp/simplecloud/plugin/sign/shared/repository/layout/LayoutRepository;", "serializers", "Lapp/simplecloud/signs/plugin/relocate/spongepowered/configurate/serialize/TypeSerializerCollection;", "Lapp/simplecloud/signs/plugin/relocate/spongepowered/configurate/serialize/TypeSerializerCollection;", "serverCache", "Lapp/simplecloud/plugin/sign/shared/cache/ServerCache;", "start", "", "stop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "register", "group", "", "location", "(Ljava/lang/String;Ljava/lang/Object;)V", "getCloudSign", "Lapp/simplecloud/plugin/sign/shared/CloudSign;", "(Ljava/lang/Object;)Lapp/simplecloud/plugin/sign/shared/CloudSign;", "getAllLocations", "", "Lapp/simplecloud/plugin/sign/shared/config/location/SignLocation;", "getAllGroupsRegistered", "getLocationsByGroup", "removeCloudSign", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "exists", "", "map", "(Lapp/simplecloud/plugin/sign/shared/config/location/SignLocation;)Ljava/lang/Object;", "unmap", "(Ljava/lang/Object;)Lapp/simplecloud/plugin/sign/shared/config/location/SignLocation;", "getLayout", "Lapp/simplecloud/plugin/sign/shared/config/layout/LayoutConfig;", "context", "Lapp/simplecloud/plugin/sign/shared/rule/impl/RuleContext;", "checkMatches", "matchers", "", "Lapp/simplecloud/plugin/sign/shared/config/matcher/MatcherType;", "Lapp/simplecloud/plugin/sign/shared/config/matcher/MatcherConfigEntry;", "serverName", "loadConfigurations", "startUpdateSignJob", "updateSigns", "locationsConfig", "Lapp/simplecloud/plugin/sign/shared/config/location/LocationsConfig;", "servers", "Lapp/simplecloud/signs/plugin/relocate/controller/shared/server/Server;", "(Lapp/simplecloud/plugin/sign/shared/config/location/LocationsConfig;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processLocation", "locationConfig", "unusedServers", "", "allServers", "(Lapp/simplecloud/plugin/sign/shared/config/location/SignLocation;Ljava/util/Iterator;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateSign", "cloudSign", "(Lapp/simplecloud/plugin/sign/shared/CloudSign;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateLayoutIndexes", "Companion", "sign-shared"})
@SourceDebugExtension(value={"SMAP\nSignManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignManager.kt\napp/simplecloud/plugin/sign/shared/SignManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,248:1\n1557#2:249\n1628#2,3:250\n1557#2:253\n1628#2,3:254\n1755#2,3:257\n1734#2,3:263\n1755#2,3:266\n1863#2,2:269\n1863#2,2:272\n295#2,2:274\n1863#2,2:276\n1755#2,3:278\n618#3:260\n183#3,2:261\n607#3:271\n*S KotlinDebug\n*F\n+ 1 SignManager.kt\napp/simplecloud/plugin/sign/shared/SignManager\n*L\n90#1:249\n90#1:250,3\n94#1:253\n94#1:254,3\n106#1:257,3\n127#1:263,3\n137#1:266,3\n168#1:269,2\n186#1:272,2\n199#1:274,2\n228#1:276,2\n181#1:278,3\n117#1:260\n121#1:261,2\n183#1:271\n*E\n"})
public final class SignManager<T>
implements SignService<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ControllerApi.Coroutine controllerApi;
    @NotNull
    private final LocationMapper<T> locationMapper;
    @NotNull
    private final RuleRegistry ruleRegistry;
    @NotNull
    private final SignUpdater<T> signUpdater;
    private final Logger logger;
    @NotNull
    private final SignState<T> state;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job updateJob;
    @NotNull
    private final LocationsRepository<T> locationsRepository;
    @NotNull
    private final LayoutRepository layoutRepository;
    private final TypeSerializerCollection serializers;
    @NotNull
    private final ServerCache<T> serverCache;
    private static final long UPDATE_INTERVAL = 50L;
    @Nullable
    private static RuleRegistry staticRuleRegistry;

    /*
     * WARNING - void declaration
     */
    public SignManager(@NotNull ControllerApi.Coroutine controllerApi, @NotNull Path directoryPath, @NotNull LocationMapper<T> locationMapper, @NotNull RuleRegistry ruleRegistry, @NotNull SignUpdater<T> signUpdater) {
        void $this$serializers_u24lambda_u240;
        TypeSerializerCollection.Builder builder2;
        Intrinsics.checkNotNullParameter(controllerApi, "controllerApi");
        Intrinsics.checkNotNullParameter(directoryPath, "directoryPath");
        Intrinsics.checkNotNullParameter(locationMapper, "locationMapper");
        Intrinsics.checkNotNullParameter(ruleRegistry, "ruleRegistry");
        Intrinsics.checkNotNullParameter(signUpdater, "signUpdater");
        this.controllerApi = controllerApi;
        this.locationMapper = locationMapper;
        this.ruleRegistry = ruleRegistry;
        this.signUpdater = signUpdater;
        this.logger = LoggerFactory.getLogger(SignManager.class);
        this.state = new SignState(null, null, null, 7, null);
        this.scope = CoroutineScopeKt.CoroutineScope(SupervisorKt.SupervisorJob$default(null, 1, null).plus(Dispatchers.getIO()));
        Path path2 = directoryPath.resolve("locations");
        Intrinsics.checkNotNullExpressionValue(path2, "resolve(...)");
        this.locationsRepository = new LocationsRepository<T>(path2, this.locationMapper);
        Path path3 = directoryPath.resolve("layouts");
        Intrinsics.checkNotNullExpressionValue(path3, "resolve(...)");
        this.layoutRepository = new LayoutRepository(path3);
        TypeSerializerCollection.Builder builder3 = builder2 = TypeSerializerCollection.defaults().childBuilder();
        SignManager signManager = this;
        boolean bl = false;
        $this$serializers_u24lambda_u240.register(SignRule.class, (TypeSerializer)new SignRuleSerializer(this.ruleRegistry));
        signManager.serializers = builder2.build();
        this.serverCache = new ServerCache<T>(this.getControllerApi(), this.locationsRepository);
        Companion.setRuleRegistry(this.ruleRegistry);
    }

    @Override
    @NotNull
    public ControllerApi.Coroutine getControllerApi() {
        return this.controllerApi;
    }

    public final void start() {
        Object object;
        this.logger.info("Starting SignManager");
        try {
            boolean bl = false;
            this.loadConfigurations();
            this.serverCache.startCacheJob();
            this.startUpdateSignJob();
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable error = throwable2 = throwable;
            boolean bl = false;
            this.logger.error("Failed to start SignManager", error);
            throw new IllegalStateException("Failed to start SignManager", error);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof stop.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SignManager<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop(this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.logger.info("Stopping SignManager");
                try {
                    $i$a$-runCatching-SignManager$stop$2 = false;
                    v0 = this.updateJob;
                    if (v0 != null) {
                        $continuation.L$0 = this;
                        $continuation.label = 1;
                        v1 = JobKt.cancelAndJoin(v0, $continuation);
                    }
                    ** GOTO lbl38
                }
                catch (Throwable var3_7) {
                    var2_6 = Result.constructor-impl(ResultKt.createFailure(var3_7));
                    ** GOTO lbl53
                }
                v2 = v1;
                if (v1 == var8_4) {
                    return var8_4;
                }
                ** GOTO lbl38
            }
            case 1: {
                $i$a$-runCatching-SignManager$stop$2 = false;
                this = (SignManager)$continuation.L$0;
                {
                    ResultKt.throwOnFailure($result);
                    v2 = $result;
lbl38:
                    // 3 sources

                    CoroutineScopeKt.cancel$default(this.scope, null, 1, null);
                    this.serverCache.stopCacheJob();
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v3 = this.state.clear($continuation);
                    ** if (v3 != var8_4) goto lbl45
                }
lbl44:
                // 1 sources

                return var8_4;
lbl45:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                $i$a$-runCatching-SignManager$stop$2 = false;
                this = (SignManager)$continuation.L$0;
                {
                    ResultKt.throwOnFailure($result);
                    v3 = $result;
lbl52:
                    // 2 sources

                    var2_6 = Result.constructor-impl(Unit.INSTANCE);
                }
lbl53:
                // 2 sources

                v4 = Result.exceptionOrNull-impl(var2_6);
                if (v4 == null) return Unit.INSTANCE;
                error = var3_8 = v4;
                $i$a$-onFailure-SignManager$stop$3 = false;
                this.logger.error("Error during SignManager shutdown", error);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void register(@NotNull String group, @NotNull T location) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(location, "location");
        this.logger.debug("Registering new location for group: {}", (Object)group);
        this.locationsRepository.saveLocation(group, location);
    }

    @Override
    @Nullable
    public CloudSign<T> getCloudSign(@NotNull T location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.state.getCloudSign(location);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SignLocation> getAllLocations() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.locationsRepository.getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocationsConfig locationsConfig = (LocationsConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLocations());
        }
        return CollectionsKt.flatten((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getAllGroupsRegistered() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.locationsRepository.getAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocationsConfig locationsConfig = (LocationsConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGroup());
        }
        return CollectionsKt.distinct((List)destination$iv$iv);
    }

    @Override
    @Nullable
    public List<SignLocation> getLocationsByGroup(@NotNull String group) {
        Intrinsics.checkNotNullParameter(group, "group");
        LocationsConfig locationsConfig = this.locationsRepository.find(group);
        return locationsConfig != null ? locationsConfig.getLocations() : null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object removeCloudSign(@NotNull T var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof removeCloudSign.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SignManager<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.removeCloudSign(null, this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.L$1 = location;
                $continuation.label = 1;
                v0 = this.state.removeCloudSign(location, $continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                location = $continuation.L$1;
                this = (SignManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl24:
                // 2 sources

                this.locationsRepository.removeLocation(location);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public boolean exists(@NotNull String group) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(group, "group");
            Iterable $this$any$iv = this.locationsRepository.getAll();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LocationsConfig it = (LocationsConfig)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getGroup(), group)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public T map(@NotNull SignLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.locationMapper.map(location);
    }

    @Override
    @NotNull
    public SignLocation unmap(@NotNull T location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.locationMapper.unmap(location);
    }

    @NotNull
    public final LayoutConfig getLayout(@NotNull RuleContext context) {
        LayoutConfig layoutConfig;
        LayoutConfig layoutConfig2;
        block2: {
            Intrinsics.checkNotNullParameter(context, "context");
            Server server = context.getServer();
            Server server2 = context.getServer();
            String serverName = (server != null ? server.getGroup() : null) + "-" + (server2 != null ? Integer.valueOf(server2.getNumericalId()) : null);
            Sequence $this$sortedByDescending$iv = CollectionsKt.asSequence(this.layoutRepository.getAll());
            boolean $i$f$sortedByDescending = false;
            Sequence<LayoutConfig> $this$firstOrNull$iv = SequencesKt.filter(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    LayoutConfig it = (LayoutConfig)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (LayoutConfig)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getPriority());
                }
            }), arg_0 -> SignManager.getLayout$lambda$9(this, context, arg_0));
            boolean $i$f$firstOrNull = false;
            Iterator<LayoutConfig> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                LayoutConfig element$iv;
                LayoutConfig layoutConfig3 = element$iv = iterator2.next();
                boolean bl = false;
                if (!this.checkMatches(layoutConfig3.getMatcher(), serverName)) continue;
                layoutConfig2 = element$iv;
                break block2;
            }
            layoutConfig2 = null;
        }
        if ((layoutConfig = (LayoutConfig)layoutConfig2) == null) {
            layoutConfig = new LayoutConfig(null, null, null, 0, null, 0L, null, 127, null);
        }
        return layoutConfig;
    }

    private final boolean checkMatches(Map<MatcherType, ? extends List<MatcherConfigEntry>> matchers, String serverName) {
        if (matchers.containsKey((Object)MatcherType.MATCH_ALL)) {
            boolean matchAllResult;
            block13: {
                List<MatcherConfigEntry> list = matchers.get((Object)MatcherType.MATCH_ALL);
                if (list != null) {
                    Iterable $this$all$iv = list;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v1 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            MatcherConfigEntry it = (MatcherConfigEntry)element$iv;
                            boolean bl = false;
                            if (it.getOperation().matches(serverName, it.getValue())) continue;
                            v1 = false;
                            break block13;
                        }
                        v1 = true;
                    }
                } else {
                    v1 = matchAllResult = false;
                }
            }
            if (!matchAllResult) {
                return false;
            }
        }
        if (matchers.containsKey((Object)MatcherType.MATCH_ANY)) {
            boolean bl;
            block14: {
                List<MatcherConfigEntry> list = matchers.get((Object)MatcherType.MATCH_ANY);
                if (list != null) {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MatcherConfigEntry it = (MatcherConfigEntry)element$iv;
                            boolean bl2 = false;
                            if (!it.getOperation().matches(serverName, it.getValue())) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            return bl;
        }
        return true;
    }

    private final void loadConfigurations() {
        LoadableRepository.DefaultImpls.load$default(this.locationsRepository, null, 1, null);
        this.layoutRepository.load(this.serializers);
        this.logger.info("Loaded {} Sign Layouts", (Object)this.layoutRepository.getAll().size());
    }

    private final void startUpdateSignJob() {
        this.updateJob = BuildersKt.launch$default(this.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SignManager<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                        }
                        catch (CancellationException exception) {
                            throw exception;
                        }
                        catch (Exception exception) {
                            SignManager.access$getLogger$p(this.this$0).error("Error in update job", exception);
                            return Unit.INSTANCE;
                        }
lbl14:
                        // 3 sources

                        while (CoroutineScopeKt.isActive($this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = SignManager.access$updateLayoutIndexes(this.this$0, this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl27
                        }
                        return Unit.INSTANCE;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl27:
                            // 2 sources

                            this.L$0 = $this$launch;
                            this.label = 2;
                            v1 = SignManager.access$updateSigns(this.this$0, this);
                            ** if (v1 != var4_2) goto lbl32
                        }
lbl31:
                        // 1 sources

                        return var4_2;
lbl32:
                        // 1 sources

                        ** GOTO lbl38
                    }
                    case 2: {
                        $this$launch = (CoroutineScope)this.L$0;
                        {
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl38:
                            // 2 sources

                            this.L$0 = $this$launch;
                            this.label = 3;
                            v2 = DelayKt.delay(50L, this);
                            if (v2 != var4_2) ** GOTO lbl14
                        }
                        return var4_2;
                    }
                    case 3: {
                        $this$launch = (CoroutineScope)this.L$0;
                        {
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
                            ** GOTO lbl14
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateSigns(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateSigns.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SignManager<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SignManager.access$updateSigns(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $this$forEach$iv = this.locationsRepository.getAll();
                $i$f$forEach = false;
                var4_7 = $this$forEach$iv.iterator();
lbl15:
                // 3 sources

                while (var4_7.hasNext()) {
                    element$iv = var4_7.next();
                    config = (LocationsConfig)element$iv;
                    $i$a$-forEach-SignManager$updateSigns$2 = false;
                    servers = this.serverCache.getServersByGroup(config.getGroup());
                    $continuation.L$0 = this;
                    $continuation.L$1 = var4_7;
                    $continuation.label = 1;
                    v0 = this.updateSigns(config, servers, $continuation);
                    if (v0 != var11_4) continue;
                    return var11_4;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-SignManager$updateSigns$2 = false;
                var4_7 = (Iterator<T>)$continuation.L$1;
                this = (SignManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl15
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateSigns(LocationsConfig var1_1, List<Server> var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateSigns.3)) ** GOTO lbl-1000
        var12_4 = $completion;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ SignManager<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SignManager.access$updateSigns(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $this$sortedBy$iv = SequencesKt.filter(SequencesKt.filterNot(CollectionsKt.asSequence(servers), (Function1<Server, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, updateSigns$lambda$14(app.simplecloud.plugin.sign.shared.SignManager app.simplecloud.signs.plugin.relocate.controller.shared.server.Server ), (Lapp/simplecloud/signs/plugin/relocate/controller/shared/server/Server;)Ljava/lang/Boolean;)((SignManager)this)), (Function1<Server, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, updateSigns$lambda$16(app.simplecloud.plugin.sign.shared.SignManager app.simplecloud.signs.plugin.relocate.controller.shared.server.Server ), (Lapp/simplecloud/signs/plugin/relocate/controller/shared/server/Server;)Ljava/lang/Boolean;)((SignManager)this));
                $i$f$sortedBy = false;
                unusedServers = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Server it = (Server)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getNumericalId());
                        it = (Server)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getNumericalId());
                    }
                }).iterator();
                $this$forEach$iv = locationsConfig.getLocations();
                $i$f$forEach = false;
                var7_10 = $this$forEach$iv.iterator();
lbl18:
                // 3 sources

                while (var7_10.hasNext()) {
                    element$iv = var7_10.next();
                    locationConfig = (SignLocation)element$iv;
                    $i$a$-forEach-SignManager$updateSigns$4 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = servers;
                    $continuation.L$2 = unusedServers;
                    $continuation.L$3 = var7_10;
                    $continuation.label = 1;
                    v0 = this.processLocation(locationConfig, unusedServers, servers, $continuation);
                    if (v0 != var13_6) continue;
                    return var13_6;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-SignManager$updateSigns$4 = false;
                var7_10 = (Iterator<T>)$continuation.L$3;
                unusedServers = (Iterator<Server>)$continuation.L$2;
                servers = (List)$continuation.L$1;
                this = (SignManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl18
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object processLocation(SignLocation locationConfig, Iterator<Server> unusedServers, List<Server> allServers, Continuation<? super Unit> $completion) {
        Server server;
        T mappedLocation = this.locationMapper.map(locationConfig);
        CloudSign<T> existingSign = this.state.getCloudSign(mappedLocation);
        CloudSign<T> cloudSign = existingSign;
        if (cloudSign != null && (cloudSign = cloudSign.getServer()) != null && (cloudSign = ((Server)((Object)cloudSign)).getUniqueId()) != null) {
            Object v1;
            block4: {
                CloudSign<T> uniqueId = cloudSign;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = allServers;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Server it = (Server)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getUniqueId(), uniqueId)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            server = v1;
        } else {
            server = null;
        }
        Server currentServer = server;
        CloudSign newSign = existingSign == null || currentServer == null ? new CloudSign(mappedLocation, (Server)SignManagerKt.access$nextOrNull(unusedServers)) : CloudSign.copy$default(existingSign, null, currentServer, 1, null);
        Object object = this.updateSign(newSign, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateSign(CloudSign<T> var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateSign.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SignManager<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SignManager.access$updateSign(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.L$1 = cloudSign;
                $continuation.label = 1;
                v0 = this.state.updateCloudSign(cloudSign.getLocation(), cloudSign, $continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                cloudSign = (CloudSign)$continuation.L$1;
                this = (SignManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = cloudSign.getServer();
                context = new RuleContext(cloudSign.getServer(), v1 != null ? v1.getState() : null, null, 4, null);
                layout = this.getLayout(context);
                if (layout.getFrames().isEmpty()) {
                    return Unit.INSTANCE;
                }
                currentFrameIndex = this.state.getCurrentFrameIndex(layout.getName());
                currentFrame = layout.getFrames().get(currentFrameIndex);
                this.signUpdater.update(cloudSign, currentFrame);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateLayoutIndexes(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateLayoutIndexes.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ SignManager<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SignManager.access$updateLayoutIndexes(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $this$forEach$iv = this.layoutRepository.getAll();
                $i$f$forEach = false;
                var4_7 = $this$forEach$iv.iterator();
lbl15:
                // 4 sources

                while (var4_7.hasNext()) {
                    element$iv = var4_7.next();
                    layout = (LayoutConfig)element$iv;
                    $i$a$-forEach-SignManager$updateLayoutIndexes$2 = false;
                    if (!this.state.shouldUpdateFrame(layout.getName(), layout.getFrameUpdateInterval())) continue;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var4_7;
                    $continuation.label = 1;
                    v0 = this.state.updateFrameIndex(layout.getName(), layout.getFrames().size(), $continuation);
                    if (v0 != var10_4) continue;
                    return var10_4;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-SignManager$updateLayoutIndexes$2 = false;
                var4_7 = (Iterator<T>)$continuation.L$1;
                this = (SignManager)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl15
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean getLayout$lambda$9(SignManager this$0, RuleContext $context, LayoutConfig layoutConfig) {
        Intrinsics.checkNotNullParameter(layoutConfig, "layoutConfig");
        SignRule rule = this$0.ruleRegistry.getRule(layoutConfig.getRule().getRuleName());
        Object object = rule;
        return object != null && (object = object.getChecker()) != null ? object.check($context) : false;
    }

    private static final boolean updateSigns$lambda$14(SignManager this$0, Server server) {
        Intrinsics.checkNotNullParameter(server, "server");
        return this$0.state.isServerAssigned(server.getUniqueId());
    }

    private static final boolean updateSigns$lambda$16(SignManager this$0, Server server) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(server, "server");
            RuleContext context = new RuleContext(server, server.getState(), null, 4, null);
            Iterable $this$any$iv = this$0.ruleRegistry.getRules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SignRule rule = (SignRule)element$iv;
                    boolean bl2 = false;
                    if (!rule.getChecker().check(context)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Object access$updateLayoutIndexes(SignManager $this, Continuation $completion) {
        return $this.updateLayoutIndexes($completion);
    }

    public static final /* synthetic */ Object access$updateSigns(SignManager $this, Continuation $completion) {
        return $this.updateSigns($completion);
    }

    public static final /* synthetic */ Logger access$getLogger$p(SignManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$updateSigns(SignManager $this, LocationsConfig locationsConfig, List servers, Continuation $completion) {
        return $this.updateSigns(locationsConfig, servers, $completion);
    }

    public static final /* synthetic */ Object access$processLocation(SignManager $this, SignLocation locationConfig, Iterator unusedServers, List allServers, Continuation $completion) {
        return $this.processLocation(locationConfig, unusedServers, allServers, $completion);
    }

    public static final /* synthetic */ Object access$updateSign(SignManager $this, CloudSign cloudSign, Continuation $completion) {
        return $this.updateSign(cloudSign, $completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/simplecloud/plugin/sign/shared/SignManager$Companion;", "", "<init>", "()V", "UPDATE_INTERVAL", "", "staticRuleRegistry", "Lapp/simplecloud/plugin/sign/shared/rule/RuleRegistry;", "getRuleRegistry", "setRuleRegistry", "", "registry", "sign-shared"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final RuleRegistry getRuleRegistry() {
            return staticRuleRegistry;
        }

        public final void setRuleRegistry(@NotNull RuleRegistry registry) {
            Intrinsics.checkNotNullParameter(registry, "registry");
            staticRuleRegistry = registry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

