/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.collect;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.collect.AbstractIterator;
import app.simplecloud.relocate.google.common.collect.ElementTypesAreNonnullByDefault;
import java.util.Queue;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

