/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.xml;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.escape.Escaper;
import app.simplecloud.relocate.google.common.escape.Escapers;
import app.simplecloud.relocate.google.common.xml.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public class XmlEscapers {
    private static final char MIN_ASCII_CONTROL_CHAR = '\u0000';
    private static final char MAX_ASCII_CONTROL_CHAR = '\u001f';
    private static final Escaper XML_ESCAPER;
    private static final Escaper XML_CONTENT_ESCAPER;
    private static final Escaper XML_ATTRIBUTE_ESCAPER;

    private XmlEscapers() {
    }

    public static Escaper xmlContentEscaper() {
        return XML_CONTENT_ESCAPER;
    }

    public static Escaper xmlAttributeEscaper() {
        return XML_ATTRIBUTE_ESCAPER;
    }

    static {
        Escapers.Builder builder2 = Escapers.builder();
        builder2.setSafeRange('\u0000', '\ufffd');
        builder2.setUnsafeReplacement("\ufffd");
        for (char c = '\u0000'; c <= '\u001f'; c = (char)((char)(c + 1))) {
            if (c == 9 || c == 10 || c == 13) continue;
            builder2.addEscape(c, "\ufffd");
        }
        builder2.addEscape('&', "&amp;");
        builder2.addEscape('<', "&lt;");
        builder2.addEscape('>', "&gt;");
        XML_CONTENT_ESCAPER = builder2.build();
        builder2.addEscape('\'', "&apos;");
        builder2.addEscape('\"', "&quot;");
        XML_ESCAPER = builder2.build();
        builder2.addEscape('\t', "&#x9;");
        builder2.addEscape('\n', "&#xA;");
        builder2.addEscape('\r', "&#xD;");
        XML_ATTRIBUTE_ESCAPER = builder2.build();
    }
}

