/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.local;

import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.Channel;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.ChannelException;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.channel.local.LocalAddress;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;

final class LocalChannelRegistry {
    private static final ConcurrentMap<LocalAddress, Channel> boundChannels = PlatformDependent.newConcurrentHashMap();

    static LocalAddress register(Channel channel2, LocalAddress oldLocalAddress, SocketAddress localAddress) {
        Channel boundChannel;
        if (oldLocalAddress != null) {
            throw new ChannelException("already bound");
        }
        if (!(localAddress instanceof LocalAddress)) {
            throw new ChannelException("unsupported address type: " + StringUtil.simpleClassName(localAddress));
        }
        LocalAddress addr = (LocalAddress)localAddress;
        if (LocalAddress.ANY.equals(addr)) {
            addr = new LocalAddress(channel2);
        }
        if ((boundChannel = boundChannels.putIfAbsent(addr, channel2)) != null) {
            throw new ChannelException("address already in use by: " + boundChannel);
        }
        return addr;
    }

    static Channel get(SocketAddress localAddress) {
        return (Channel)boundChannels.get(localAddress);
    }

    static void unregister(LocalAddress localAddress) {
        boundChannels.remove(localAddress);
    }

    private LocalChannelRegistry() {
    }
}

