/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.injection;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.injection.InjectionRequest;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.injection.InjectionService;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.util.annotation.AnnotationAccessor;
import com.google.inject.BindingAnnotation;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.STABLE)
public final class GuiceInjectionService<C>
implements InjectionService<C> {
    private final Injector injector;

    private static <T> @NonNull Key<T> createKey(@NonNull Class<T> clazz, @NonNull AnnotationAccessor annotationAccessor) {
        Annotation bindingAnnotation = annotationAccessor.annotations().stream().filter(annotation -> annotation.annotationType().isAnnotationPresent(BindingAnnotation.class)).findFirst().orElse(null);
        if (bindingAnnotation == null) {
            return Key.get(clazz);
        }
        return Key.get(clazz, (Annotation)bindingAnnotation);
    }

    private GuiceInjectionService(@NonNull Injector injector) {
        this.injector = injector;
    }

    public static <C> @NonNull GuiceInjectionService<C> create(@NonNull Injector injector) {
        return new GuiceInjectionService<C>(injector);
    }

    @Override
    public @Nullable Object handle(@NonNull InjectionRequest<C> request2) {
        try {
            return this.injector.getInstance(GuiceInjectionService.createKey(request2.injectedClass(), request2.annotationAccessor()));
        }
        catch (ConfigurationException ignored) {
            return null;
        }
    }
}

