/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.paper;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.SenderMapper;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCommandContextKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCommandManager;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.PluginHolder;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.internal.BukkitHelper;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.internal.CraftBukkitReflection;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.preprocessor.CommandPreprocessingContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.preprocessor.CommandPreprocessor;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

final class PaperCommandPreprocessor<B, C>
implements CommandPreprocessor<C> {
    private static final boolean FOLIA = CraftBukkitReflection.classExists("io.papermc.paper.threadedregions.RegionizedServer");
    private final PluginHolder pluginHolder;
    private final SenderMapper<B, C> mapper;
    private final Function<B, CommandSender> senderExtractor;

    PaperCommandPreprocessor(PluginHolder pluginHolder, SenderMapper<B, C> mapper, Function<B, CommandSender> senderExtractor) {
        this.pluginHolder = pluginHolder;
        this.mapper = mapper;
        this.senderExtractor = senderExtractor;
    }

    @Override
    public void accept(CommandPreprocessingContext<C> ctx) {
        if (FOLIA) {
            ctx.commandContext().store(BukkitCommandContextKeys.SENDER_SCHEDULER_EXECUTOR, this.foliaExecutorFor(ctx.commandContext().sender()));
        } else if (!(this.pluginHolder instanceof BukkitCommandManager)) {
            ctx.commandContext().store(BukkitCommandContextKeys.SENDER_SCHEDULER_EXECUTOR, BukkitHelper.mainThreadExecutor(this.pluginHolder));
        }
    }

    private Executor foliaExecutorFor(C sender2) {
        CommandSender commandSender = this.senderExtractor.apply(this.mapper.reverse(sender2));
        Plugin plugin = this.pluginHolder.owningPlugin();
        if (commandSender instanceof Entity) {
            return task2 -> ((Entity)commandSender).getScheduler().run(plugin, handle -> task2.run(), null);
        }
        if (commandSender instanceof BlockCommandSender) {
            BlockCommandSender blockSender = (BlockCommandSender)commandSender;
            return task2 -> blockSender.getServer().getRegionScheduler().run(plugin, blockSender.getBlock().getLocation(), handle -> task2.run());
        }
        return task2 -> plugin.getServer().getGlobalRegionScheduler().run(plugin, handle -> task2.run());
    }
}

