/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.suggestion;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.LegacyPaperCommandManager;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.suggestion.AsyncCommandSuggestionListener;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.suggestion.tooltips.CompletionMapper;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.paper.suggestion.tooltips.CompletionMapperFactory;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.SuggestionFactory;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.Suggestions;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.util.StringUtils;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class BrigadierAsyncCommandSuggestionListener<C>
extends AsyncCommandSuggestionListener<C> {
    private final CompletionMapperFactory completionMapperFactory = CompletionMapperFactory.detectingRelocation();
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    BrigadierAsyncCommandSuggestionListener(@NonNull LegacyPaperCommandManager<C> paperCommandManager) {
        super(paperCommandManager);
        this.suggestionFactory = paperCommandManager.suggestionFactory().mapped(TooltipSuggestion::tooltipSuggestion);
    }

    @Override
    @EventHandler
    void onTabCompletion(@NonNull AsyncTabCompleteEvent event) {
        super.onTabCompletion(event);
    }

    @Override
    protected Suggestions<C, ? extends TooltipSuggestion> querySuggestions(@NonNull C commandSender, @NonNull String input2) {
        return this.suggestionFactory.suggestImmediately(commandSender, input2);
    }

    @Override
    protected void setSuggestions(@NonNull AsyncTabCompleteEvent event, @NonNull C commandSender, @NonNull String input2) {
        CompletionMapper completionMapper = this.completionMapperFactory.createMapper();
        Suggestions suggestions = this.querySuggestions(commandSender, input2);
        event.completions(suggestions.list().stream().map(suggestion -> {
            @Nullable String trim = StringUtils.trimBeforeLastSpace(suggestion.suggestion(), suggestions.commandInput());
            if (trim == null) {
                return null;
            }
            return suggestion.withSuggestion(trim);
        }).filter(Objects::nonNull).map(completionMapper::map).collect(Collectors.toList()));
    }
}

