/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.standard;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.StandardCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public final class CharacterParser<C>
implements ArgumentParser<C, Character> {
    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Character> characterParser() {
        return ParserDescriptor.of(new CharacterParser<C>(), Character.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Character> characterComponent() {
        return CommandComponent.builder().parser(CharacterParser.characterParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Character> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (commandInput.peekString().length() != 1) {
            return ArgumentParseResult.failure(new CharParseException(commandInput.peekString(), commandContext));
        }
        return ArgumentParseResult.success(Character.valueOf(commandInput.read()));
    }

    @API(status=API.Status.STABLE)
    public static final class CharParseException
    extends ParserException {
        private final String input;

        public CharParseException(@NonNull String input2, @NonNull CommandContext<?> context) {
            super(CharacterParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_CHAR, CaptionVariable.of("input", input2));
            this.input = input2;
        }

        public @NonNull String input() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharParseException that = (CharParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

