/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.standard;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.StandardCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import java.util.Objects;
import java.util.UUID;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public final class UUIDParser<C>
implements ArgumentParser<C, UUID> {
    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, UUID> uuidParser() {
        return ParserDescriptor.of(new UUIDParser<C>(), UUID.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, UUID> uuidComponent() {
        return CommandComponent.builder().parser(UUIDParser.uuidParser());
    }

    @Override
    public @NonNull ArgumentParseResult<UUID> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input2 = commandInput.readString();
        try {
            UUID uuid = UUID.fromString(input2);
            return ArgumentParseResult.success(uuid);
        }
        catch (IllegalArgumentException e) {
            return ArgumentParseResult.failure(new UUIDParseException(input2, commandContext));
        }
    }

    @API(status=API.Status.STABLE)
    public static final class UUIDParseException
    extends ParserException {
        private final String input;

        public UUIDParseException(@NonNull String input2, @NonNull CommandContext<?> context) {
            super(UUIDParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_UUID, CaptionVariable.of("input", input2));
            this.input = input2;
        }

        public String input() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UUIDParseException that = (UUIDParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

