/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.execution.CommandExecutionHandler;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation.ConfirmationContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.processors.confirmation.ConfirmationManager;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, since="1.0.0")
final class ConfirmationExecutionHandler<C>
implements CommandExecutionHandler.FutureCommandExecutionHandler<C> {
    private final ConfirmationManager<C> confirmationManager;

    ConfirmationExecutionHandler(@NonNull ConfirmationManager<C> confirmationManager) {
        this.confirmationManager = Objects.requireNonNull(confirmationManager, "confirmationManager");
    }

    @Override
    public @NonNull CompletableFuture<Void> executeFuture(@NonNull CommandContext<C> commandContext) {
        Optional<ConfirmationContext<C>> pending = this.confirmationManager.popPending(commandContext.sender());
        if (pending.isEmpty()) {
            this.confirmationManager.configuration().noPendingCommandNotifier().accept(commandContext.sender());
            return CompletableFuture.completedFuture(null);
        }
        return pending.get().command().commandExecutionHandler().executeFuture(pending.get().commandContext());
    }
}

