/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reference;

import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.ConfigurateException;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.NodePath;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.ScopedConfigurationNode;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reactive.Disposable;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reactive.Publisher;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reactive.Subscriber;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reactive.TransactionFailedException;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reference.ConfigurationReference;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reference.ManualConfigurationReference;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.reference.ValueReference;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize.SerializationException;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize.TypeSerializer;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.util.UnmodifiableCollections;
import io.leangen.geantyref.TypeToken;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

class ValueReferenceImpl<@Nullable T, N extends ScopedConfigurationNode<N>>
implements ValueReference<T, N>,
Publisher<T> {
    private final ManualConfigurationReference<N> root;
    private final NodePath path;
    private final TypeToken<T> type;
    private final TypeSerializer<T> serializer;
    private final Publisher.Cached<@Nullable T> deserialized;

    ValueReferenceImpl(ManualConfigurationReference<N> root, NodePath path2, TypeToken<T> type, @Nullable T def) throws SerializationException {
        this.root = root;
        this.path = path2;
        this.type = type;
        @Nullable TypeSerializer<T> serializer2 = root.node().options().serializers().get(type);
        if (serializer2 == null) {
            throw new SerializationException(this.path, type.getType(), "Unsupported type" + type);
        }
        this.serializer = serializer2;
        this.deserialized = root.updateListener.map((I n) -> {
            try {
                return this.deserializedValueFrom(n, def);
            }
            catch (SerializationException e) {
                root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, e));
                throw new TransactionFailedException(e);
            }
        }).cache(this.deserializedValueFrom(root.node(), def));
    }

    ValueReferenceImpl(ManualConfigurationReference<N> root, NodePath path2, Class<T> type, @Nullable T def) throws SerializationException {
        this(root, path2, TypeToken.get(type), def);
    }

    private @Nullable T deserializedValueFrom(N parent, @Nullable T defaultVal) throws SerializationException {
        T defaultOrEmpty;
        ConfigurationNode node = parent.node((Iterable)this.path);
        if (!node.virtual()) {
            return this.serializer.deserialize(this.type.getType(), node);
        }
        T t2 = defaultOrEmpty = defaultVal == null ? this.serializer.emptyValue(this.type.getType(), node.options()) : defaultVal;
        if (node.options().shouldCopyDefaults()) {
            this.serializer.serialize(this.type.getType(), defaultOrEmpty, node);
        }
        return defaultOrEmpty;
    }

    @Override
    public @Nullable T get() {
        return this.deserialized.get();
    }

    @Override
    public boolean set(@Nullable T value) {
        try {
            this.serializer.serialize(this.type.getType(), value, this.node());
            this.deserialized.submit(value);
            return true;
        }
        catch (SerializationException e) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, e));
            return false;
        }
    }

    @Override
    public boolean setAndSave(@Nullable T value) {
        try {
            if (this.set(value)) {
                this.root.save();
                return true;
            }
        }
        catch (ConfigurateException e) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, e));
        }
        return false;
    }

    @Override
    public Publisher<Boolean> setAndSaveAsync(@Nullable T value) {
        return Publisher.execute(() -> {
            this.serializer.serialize(this.type.getType(), value, this.node());
            this.deserialized.submit(value);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public boolean update(Function<@Nullable T, ? extends T> action) {
        try {
            return this.set(action.apply(this.get()));
        }
        catch (Exception t2) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, t2));
            return false;
        }
    }

    @Override
    public Publisher<Boolean> updateAsync(Function<@Nullable T, ? extends T> action) {
        return Publisher.execute(() -> {
            @Nullable T orig = this.get();
            Object updated = action.apply(orig);
            this.serializer.serialize(this.type.getType(), updated, this.node());
            this.deserialized.submit(updated);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public N node() {
        return (N)this.root.node().node((Iterable)this.path);
    }

    @Override
    public Disposable subscribe(Subscriber<? super T> subscriber) {
        return this.deserialized.subscribe(subscriber);
    }

    @Override
    public boolean hasSubscribers() {
        return this.deserialized.hasSubscribers();
    }

    @Override
    public Executor executor() {
        return this.deserialized.executor();
    }
}

