/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.spongepowered.configurate.yaml;

import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.CommentedConfigurationNode;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.ConfigurationOptions;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.loader.AbstractConfigurationLoader;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.loader.CommentHandler;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.loader.CommentHandlers;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.util.UnmodifiableCollections;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.yaml.ConfigurateYaml;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.yaml.NodeStyle;
import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.yaml.snakeyaml.DumperOptions;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    private final ThreadLocal<ConfigurateYaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder2) {
        super(builder2, new CommentHandler[]{CommentHandlers.HASH});
        DumperOptions opts = builder2.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder2.style));
        this.yaml = ThreadLocal.withInitial(() -> new ConfigurateYaml(opts));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader2) {
        node.raw(this.yaml.get().loadConfigurate(reader2));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer2) {
        this.yaml.get().dump(node.raw(), writer2);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options2) {
        return CommentedConfigurationNode.root(options2);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private final DumperOptions options = new DumperOptions();
        private @Nullable NodeStyle style;

        Builder() {
            this.indent(4);
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
        }

        public Builder indent(int indent) {
            this.options.setIndent(indent);
            return this;
        }

        public int indent() {
            return this.options.getIndent();
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.style = style;
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.style;
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

