/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a;\u0010\u0002\u001a\u00020\u0003*\u00020\u00012\n\u0010\u0004\u001a\u00060\u0006j\u0002`\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a-\u0010\u0017\u001a\u00020\u0018*\u00060\u0006j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0019\u001a5\u0010\u001a\u001a\u00020\u0003*\u00060\u0006j\u0002`\u00052\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"NEL", "", "wrapText", "", "sb", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "width", "", "initialIndent", "subsequentIndent", "(Ljava/lang/String;Ljava/lang/StringBuilder;ILjava/lang/String;Ljava/lang/String;)V", "TEXT_START_REGEX", "Lkotlin/text/Regex;", "PRE_P_END_REGEX", "PLAIN_P_END_REGEX", "LINE_BREAK_REGEX", "WHITESPACE_OR_NEL_REGEX", "WORD_OR_NEL_REGEX", "PRE_P_CONTENTS_REGEX", "splitParagraphs", "", "text", "tryPreformat", "", "(Ljava/lang/StringBuilder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", "wrapParagraph", "(Ljava/lang/StringBuilder;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "clikt"})
@SourceDebugExtension(value={"SMAP\ntext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 text.kt\ncom/github/ajalt/clikt/output/TextKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class TextKt {
    @NotNull
    public static final String NEL = "\u0085";
    @NotNull
    private static final Regex TEXT_START_REGEX = new Regex("\\S");
    @NotNull
    private static final Regex PRE_P_END_REGEX = new Regex("```[ \\t]*(?:\\n\\s*|[ \\t]*$)");
    @NotNull
    private static final Regex PLAIN_P_END_REGEX = new Regex("[ \\t]*\\n(?:\\s*```|[ \\t]*\\n\\s*)|\u0085?\\s*$");
    @NotNull
    private static final Regex LINE_BREAK_REGEX = new Regex("\r?\n");
    @NotNull
    private static final Regex WHITESPACE_OR_NEL_REGEX = new Regex("\\s+|\u0085");
    @NotNull
    private static final Regex WORD_OR_NEL_REGEX = new Regex("[^\\s\u0085]+|\u0085");
    @NotNull
    private static final Regex PRE_P_CONTENTS_REGEX = new Regex("```([\\s\\S]*?)```");

    public static final void wrapText(@NotNull String $this$wrapText, @NotNull StringBuilder sb, int width, @NotNull String initialIndent, @NotNull String subsequentIndent) {
        Intrinsics.checkNotNullParameter($this$wrapText, "<this>");
        Intrinsics.checkNotNullParameter(sb, "sb");
        Intrinsics.checkNotNullParameter(initialIndent, "initialIndent");
        Intrinsics.checkNotNullParameter(subsequentIndent, "subsequentIndent");
        if (!(initialIndent.length() < width)) {
            boolean $i$a$-require-TextKt$wrapText$32 = false;
            String $i$a$-require-TextKt$wrapText$32 = "initialIndent >= width: " + initialIndent.length() + " >= " + width;
            throw new IllegalArgumentException($i$a$-require-TextKt$wrapText$32.toString());
        }
        if (!(subsequentIndent.length() < width)) {
            boolean bl = false;
            String string = "subsequentIndent >= width: " + subsequentIndent.length() + " >= " + width;
            throw new IllegalArgumentException(string.toString());
        }
        Iterator iterator2 = ((Iterable)TextKt.splitParagraphs($this$wrapText)).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            String paragraph = (String)iterator2.next();
            if (i2 > 0) {
                sb.append("\n\n");
            }
            TextKt.wrapParagraph(sb, paragraph, width, i2 == 0 ? initialIndent : subsequentIndent, subsequentIndent);
        }
    }

    public static /* synthetic */ void wrapText$default(String string, StringBuilder stringBuilder, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 78;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        TextKt.wrapText(string, stringBuilder, n, string2, string3);
    }

    @NotNull
    public static final List<String> splitParagraphs(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        List paragraphs = new ArrayList();
        Object object = Regex.find$default(TEXT_START_REGEX, text2, 0, 2, null);
        if (object == null || (object = object.getRange()) == null) {
            return CollectionsKt.emptyList();
        }
        int i2 = ((IntProgression)object).getFirst();
        while (i2 < text2.length()) {
            IntRange intRange;
            IntRange intRange2;
            MatchResult it;
            if (StringsKt.startsWith$default(text2, "```", i2, false, 4, null)) {
                if (PRE_P_END_REGEX.find(text2, i2 + 3) != null) {
                    boolean bl = false;
                    intRange2 = new IntRange(it.getRange().getFirst() + 3, it.getRange().getLast());
                } else {
                    intRange2 = null;
                }
            } else if (PLAIN_P_END_REGEX.find(text2, i2) != null) {
                boolean bl = false;
                intRange2 = StringsKt.startsWith$default(it.getValue(), NEL, false, 2, null) ? new IntRange(it.getRange().getFirst() + 1, it.getRange().getFirst() + 1) : (StringsKt.endsWith$default(it.getValue(), "```", false, 2, null) ? new IntRange(it.getRange().getFirst(), it.getRange().getLast() - 3) : it.getRange());
            } else {
                intRange2 = intRange = null;
            }
            if (intRange2 == null) {
                intRange = new IntRange(text2.length(), text2.length());
            }
            IntRange range = intRange;
            Collection collection = paragraphs;
            String string = text2.substring(i2, range.getFirst());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            collection.add(string);
            i2 = range.getLast() + 1;
        }
        return paragraphs;
    }

    private static final boolean tryPreformat(StringBuilder $this$tryPreformat, String text2, String initialIndent, String subsequentIndent) {
        Object object = PRE_P_CONTENTS_REGEX.matchEntire(text2);
        String value = object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null ? ((MatchGroup)object).getValue() : null;
        String string = value;
        if (string == null || (string = StringsKt.replaceIndent(string, subsequentIndent)) == null || (string = StringsKt.removePrefix(string, (CharSequence)subsequentIndent)) == null) {
            return false;
        }
        String pre = string;
        CharSequence charSequence = pre;
        Regex regex = LINE_BREAK_REGEX;
        int n = 0;
        Iterator iterator2 = ((Iterable)regex.split(charSequence, n)).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i2 = n2++;
            String line = (String)iterator2.next();
            StringBuilder stringBuilder = i2 == 0 ? $this$tryPreformat.append(initialIndent) : $this$tryPreformat.append("\n");
            $this$tryPreformat.append(((Object)StringsKt.trimEnd((CharSequence)line)).toString());
        }
        return true;
    }

    private static final void wrapParagraph(StringBuilder $this$wrapParagraph, String text2, int width, String initialIndent, String subsequentIndent) {
        if (TextKt.tryPreformat($this$wrapParagraph, text2, initialIndent, subsequentIndent)) {
            return;
        }
        String breakLine = '\n' + subsequentIndent;
        if (initialIndent.length() + text2.length() <= width) {
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)text2)).toString();
            Regex regex = WHITESPACE_OR_NEL_REGEX;
            Function1<MatchResult, CharSequence> function1 = arg_0 -> TextKt.wrapParagraph$lambda$4(breakLine, arg_0);
            String newText = regex.replace(charSequence, function1);
            $this$wrapParagraph.append(initialIndent).append(newText);
            return;
        }
        List<String> words = SequencesKt.toList(SequencesKt.map(Regex.findAll$default(WORD_OR_NEL_REGEX, text2, 0, 2, null), TextKt::wrapParagraph$lambda$5));
        $this$wrapParagraph.append(initialIndent);
        int currentWidth = initialIndent.length();
        boolean prevWasNel = false;
        Iterator iterator2 = ((Iterable)words).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            String word = (String)iterator2.next();
            if (Intrinsics.areEqual(word, NEL)) {
                $this$wrapParagraph.append(breakLine);
                currentWidth = subsequentIndent.length();
                prevWasNel = true;
                continue;
            }
            if (i2 > 0 && !prevWasNel) {
                if (currentWidth + word.length() + 1 > width) {
                    $this$wrapParagraph.append(breakLine);
                    currentWidth = subsequentIndent.length();
                } else {
                    $this$wrapParagraph.append(" ");
                    ++currentWidth;
                }
            }
            prevWasNel = false;
            $this$wrapParagraph.append(word);
            currentWidth += word.length();
        }
    }

    private static final CharSequence wrapParagraph$lambda$4(String $breakLine, MatchResult it) {
        Intrinsics.checkNotNullParameter($breakLine, "$breakLine");
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getValue(), NEL) ? (CharSequence)$breakLine : (CharSequence)" ";
    }

    private static final String wrapParagraph$lambda$5(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getValue();
    }
}

