/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.contentnegotiation;

import io.ktor.http.HeaderValue;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.CreatePluginUtilsKt;
import io.ktor.server.application.RouteScopedPlugin;
import io.ktor.server.application.RouteScopedPluginBuilder;
import io.ktor.server.plugins.contentnegotiation.ContentNegotiationConfig;
import io.ktor.server.plugins.contentnegotiation.ContentNegotiationKt;
import io.ktor.server.plugins.contentnegotiation.RequestConverterKt;
import io.ktor.server.plugins.contentnegotiation.ResponseConverterKt;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a#\u0010\u0004\u001a\u00060\u0001j\u0002`\u0002*\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\"\u001e\u0010\b\u001a\u00060\u0006j\u0002`\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011*\u0082\u0001\u0010\u0019\">\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00122>\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0012\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/application/ApplicationCall;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "defaultCharset", "suitableCharset", "(Lio/ktor/server/application/ApplicationCall;Ljava/nio/charset/Charset;)Ljava/nio/charset/Charset;", "Lorg/slf4j/Logger;", "Lio/ktor/util/logging/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "Lio/ktor/server/application/RouteScopedPlugin;", "Lio/ktor/server/plugins/contentnegotiation/ContentNegotiationConfig;", "ContentNegotiation", "Lio/ktor/server/application/RouteScopedPlugin;", "getContentNegotiation", "()Lio/ktor/server/application/RouteScopedPlugin;", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "call", "", "Lio/ktor/server/plugins/contentnegotiation/ContentTypeWithQuality;", "acceptedContentTypes", "AcceptHeaderContributor", "ktor-server-content-negotiation"})
public final class ContentNegotiationKt {
    @NotNull
    private static final Logger LOGGER = KtorSimpleLoggerJvmKt.KtorSimpleLogger("io.ktor.server.plugins.contentnegotiation.ContentNegotiation");
    @NotNull
    private static final RouteScopedPlugin<ContentNegotiationConfig> ContentNegotiation = CreatePluginUtilsKt.createRouteScopedPlugin("ContentNegotiation", ContentNegotiation.1.INSTANCE, ContentNegotiationKt::ContentNegotiation$lambda$0);

    @NotNull
    public static final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public static final RouteScopedPlugin<ContentNegotiationConfig> getContentNegotiation() {
        return ContentNegotiation;
    }

    @NotNull
    public static final Charset suitableCharset(@NotNull ApplicationCall $this$suitableCharset, @NotNull Charset defaultCharset) {
        Intrinsics.checkNotNullParameter($this$suitableCharset, "<this>");
        Intrinsics.checkNotNullParameter(defaultCharset, "defaultCharset");
        Iterator<HeaderValue> iterator2 = ApplicationRequestPropertiesKt.acceptCharsetItems($this$suitableCharset.getRequest()).iterator();
        while (iterator2.hasNext()) {
            String charset = iterator2.next().component1();
            if (Intrinsics.areEqual(charset, "*")) {
                return defaultCharset;
            }
            if (!CharsetJVMKt.isSupported(Charsets.INSTANCE, charset)) continue;
            return CharsetJVMKt.forName(Charsets.INSTANCE, charset);
        }
        return defaultCharset;
    }

    public static /* synthetic */ Charset suitableCharset$default(ApplicationCall applicationCall, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return ContentNegotiationKt.suitableCharset(applicationCall, charset);
    }

    private static final Unit ContentNegotiation$lambda$0(RouteScopedPluginBuilder $this$createRouteScopedPlugin) {
        Intrinsics.checkNotNullParameter($this$createRouteScopedPlugin, "$this$createRouteScopedPlugin");
        RequestConverterKt.convertRequestBody($this$createRouteScopedPlugin);
        ResponseConverterKt.convertResponseBody($this$createRouteScopedPlugin);
        return Unit.INSTANCE;
    }
}

