/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.http.HttpHeaders;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.server.sessions.SessionTransport;
import io.ktor.server.sessions.SessionTransportTransformer;
import io.ktor.server.sessions.SessionTransportTransformerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/sessions/SessionTransportHeader;", "Lio/ktor/server/sessions/SessionTransport;", "", "name", "", "Lio/ktor/server/sessions/SessionTransportTransformer;", "transformers", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "Lio/ktor/server/application/ApplicationCall;", "call", "receive", "(Lio/ktor/server/application/ApplicationCall;)Ljava/lang/String;", "value", "", "send", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;)V", "clear", "(Lio/ktor/server/application/ApplicationCall;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getName", "Ljava/util/List;", "getTransformers", "()Ljava/util/List;", "ktor-server-sessions"})
public final class SessionTransportHeader
implements SessionTransport {
    @NotNull
    private final String name;
    @NotNull
    private final List<SessionTransportTransformer> transformers;

    public SessionTransportHeader(@NotNull String name, @NotNull List<? extends SessionTransportTransformer> transformers) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(transformers, "transformers");
        this.name = name;
        this.transformers = transformers;
        HttpHeaders.INSTANCE.checkHeaderName(this.name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<SessionTransportTransformer> getTransformers() {
        return this.transformers;
    }

    @Override
    @Nullable
    public String receive(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter(call, "call");
        return SessionTransportTransformerKt.transformRead(this.transformers, call.getRequest().getHeaders().get(this.name));
    }

    @Override
    public void send(@NotNull ApplicationCall call, @NotNull String value) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(value, "value");
        ApplicationResponsePropertiesKt.header(call.getResponse(), this.name, SessionTransportTransformerKt.transformWrite(this.transformers, value));
    }

    @Override
    public void clear(@NotNull ApplicationCall call) {
        Intrinsics.checkNotNullParameter(call, "call");
    }

    @NotNull
    public String toString() {
        return "SessionTransportHeader: " + this.name;
    }
}

