/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0011\u0010\u0005\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\b\u001a\u0013\u0010\t\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\t\u0010\u0006\u001a\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0013\u0010\u0010\u001a\u00020\u000f*\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0013\u0010\u0012\u001a\u00020\u000f*\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011\u001a\u0013\u0010\f\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\f\u0010\u0006\u00a8\u0006\u0013"}, d2={"Ljava/io/File;", "", "relativePath", "combineSafe", "(Ljava/io/File;Ljava/lang/String;)Ljava/io/File;", "normalizeAndRelativize", "(Ljava/io/File;)Ljava/io/File;", "dir", "(Ljava/io/File;Ljava/io/File;)Ljava/io/File;", "notRooted", "path", "", "dropLeadingTopDirs", "(Ljava/lang/String;)I", "", "", "isPathSeparator", "(C)Z", "isPathSeparatorOrDot", "ktor-utils"})
@SourceDebugExtension(value={"SMAP\nPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path.kt\nio/ktor/util/PathKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,98:1\n1#2:99\n413#3,4:100\n*S KotlinDebug\n*F\n+ 1 Path.kt\nio/ktor/util/PathKt\n*L\n42#1:100,4\n*E\n"})
public final class PathKt {
    @NotNull
    public static final File combineSafe(@NotNull File $this$combineSafe, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter($this$combineSafe, "<this>");
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        return PathKt.combineSafe($this$combineSafe, new File(relativePath));
    }

    @NotNull
    public static final File normalizeAndRelativize(@NotNull File $this$normalizeAndRelativize) {
        Intrinsics.checkNotNullParameter($this$normalizeAndRelativize, "<this>");
        return PathKt.dropLeadingTopDirs(PathKt.notRooted(FilesKt.normalize($this$normalizeAndRelativize)));
    }

    private static final File combineSafe(File dir, File relativePath) {
        File normalized = PathKt.normalizeAndRelativize(relativePath);
        if (FilesKt.startsWith(normalized, "..")) {
            throw new IllegalArgumentException("Bad relative path " + relativePath);
        }
        if (!(!normalized.isAbsolute())) {
            boolean bl = false;
            String string = "Bad relative path " + relativePath;
            throw new IllegalStateException(string.toString());
        }
        return new File(dir, normalized.getPath());
    }

    private static final File notRooted(File $this$notRooted) {
        String string;
        block3: {
            if (!FilesKt.isRooted($this$notRooted)) {
                return $this$notRooted;
            }
            File current = $this$notRooted;
            while (current.getParentFile() != null) {
                File parent;
                current = parent;
            }
            String string2 = $this$notRooted.getPath();
            Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
            String $this$dropWhile$iv = StringsKt.drop(string2, current.getName().length());
            boolean $i$f$dropWhile = false;
            int n = ((CharSequence)$this$dropWhile$iv).length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$dropWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '\\' || it == '/') continue;
                String string3 = $this$dropWhile$iv.substring(index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                break block3;
            }
            string = "";
        }
        String string4 = string;
        return new File(string4);
    }

    public static final int dropLeadingTopDirs(@NotNull String path2) {
        Intrinsics.checkNotNullParameter(path2, "path");
        int startIndex = 0;
        int lastIndex = path2.length() - 1;
        while (startIndex <= lastIndex) {
            int n;
            char first2 = path2.charAt(startIndex);
            if (PathKt.isPathSeparator(first2)) {
                ++startIndex;
                continue;
            }
            if (first2 != '.') break;
            if (startIndex == lastIndex) {
                ++startIndex;
                break;
            }
            char second2 = path2.charAt(startIndex + 1);
            if (PathKt.isPathSeparator(second2)) {
                n = 2;
            } else {
                if (second2 != '.') break;
                if (startIndex + 2 == path2.length()) {
                    n = 2;
                } else {
                    if (!PathKt.isPathSeparator(path2.charAt(startIndex + 2))) break;
                    n = 3;
                }
            }
            startIndex = startIndex + n;
        }
        return startIndex;
    }

    private static final boolean isPathSeparator(char $this$isPathSeparator) {
        return $this$isPathSeparator == '\\' || $this$isPathSeparator == '/';
    }

    private static final boolean isPathSeparatorOrDot(char $this$isPathSeparatorOrDot) {
        return $this$isPathSeparatorOrDot == '.' || PathKt.isPathSeparator($this$isPathSeparatorOrDot);
    }

    private static final File dropLeadingTopDirs(File $this$dropLeadingTopDirs) {
        int startIndex;
        String string = $this$dropLeadingTopDirs.getPath();
        if (string == null) {
            string = "";
        }
        if ((startIndex = PathKt.dropLeadingTopDirs(string)) == 0) {
            return $this$dropLeadingTopDirs;
        }
        if (startIndex >= $this$dropLeadingTopDirs.getPath().length()) {
            return new File(".");
        }
        String string2 = $this$dropLeadingTopDirs.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        String string3 = string2.substring(startIndex);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        return new File(string3);
    }
}

