/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.parser;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.CommandManager;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitCaptionKeys;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.bukkit.BukkitParserParameters;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.Caption;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.Objects;
import org.apiguardian.api.API;
import org.bukkit.NamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NamespacedKeyParser<C>
implements ArgumentParser<C, NamespacedKey>,
BlockingSuggestionProvider.Strings<C> {
    private final boolean requireExplicitNamespace;
    private final String defaultNamespace;

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, NamespacedKey> namespacedKeyParser() {
        return NamespacedKeyParser.namespacedKeyParser(false);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, NamespacedKey> namespacedKeyParser(boolean requireExplicitNamespace) {
        return NamespacedKeyParser.namespacedKeyParser(requireExplicitNamespace, "minecraft");
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, NamespacedKey> namespacedKeyParser(boolean requireExplicitNamespace, @NonNull String defaultNamespace) {
        return ParserDescriptor.of(new NamespacedKeyParser<C>(requireExplicitNamespace, defaultNamespace), NamespacedKey.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, NamespacedKey> namespacedKeyComponent() {
        return CommandComponent.builder().parser(NamespacedKeyParser.namespacedKeyParser());
    }

    public NamespacedKeyParser(boolean requireExplicitNamespace, String defaultNamespace) {
        this.requireExplicitNamespace = requireExplicitNamespace;
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public @NonNull ArgumentParseResult<NamespacedKey> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        int maxSemi;
        String input2 = commandInput.peekString();
        String[] split2 = input2.split(":");
        int n = maxSemi = split2.length > 1 ? 1 : 0;
        if (input2.length() - input2.replace(":", "").length() > maxSemi) {
            return ArgumentParseResult.failure(new NamespacedKeyParseException(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_KEY, input2, commandContext));
        }
        try {
            NamespacedKey ret2;
            if (split2.length == 1) {
                if (this.requireExplicitNamespace) {
                    return ArgumentParseResult.failure(new NamespacedKeyParseException(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_NEED_NAMESPACE, input2, commandContext));
                }
                ret2 = new NamespacedKey(this.defaultNamespace, commandInput.readString());
            } else if (split2.length == 2) {
                ret2 = new NamespacedKey(commandInput.readUntilAndSkip(':'), commandInput.readString());
            } else {
                return ArgumentParseResult.failure(new NamespacedKeyParseException(BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_KEY, input2, commandContext));
            }
            return ArgumentParseResult.success(ret2);
        }
        catch (IllegalArgumentException ex) {
            Caption caption = ex.getMessage().contains("namespace") ? BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_NAMESPACE : BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_NAMESPACED_KEY_KEY;
            return ArgumentParseResult.failure(new NamespacedKeyParseException(caption, input2, commandContext));
        }
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input2) {
        ArrayList<String> ret2 = new ArrayList<String>();
        ret2.add(this.defaultNamespace + ":");
        String token = input2.peekString();
        if (!token.contains(":") && !token.isEmpty()) {
            ret2.add(token + ":");
        }
        return ret2;
    }

    private static <C> void registerParserSupplier(@NonNull CommandManager<C> commandManager) {
        commandManager.parserRegistry().registerParserSupplier(TypeToken.get(NamespacedKey.class), params -> new NamespacedKeyParser(params.has(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE), params.get(BukkitParserParameters.DEFAULT_NAMESPACE, "minecraft")));
    }

    public static final class NamespacedKeyParseException
    extends ParserException {
        private final String input;

        public NamespacedKeyParseException(@NonNull Caption caption, @NonNull String input2, @NonNull CommandContext<?> context) {
            super(NamespacedKeyParser.class, context, caption, CaptionVariable.of("input", input2));
            this.input = input2;
        }

        public @NonNull String input() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamespacedKeyParseException that = (NamespacedKeyParseException)o;
            return this.input.equals(that.input) && this.errorCaption().equals(that.errorCaption());
        }

        public int hashCode() {
            return Objects.hash(this.input, this.errorCaption());
        }
    }
}

