/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.standard;

import app.simplecloud.signs.plugin.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.exception.parsing.NumberParseException;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.parser.standard.NumberParser;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.type.range.FloatRange;
import app.simplecloud.signs.plugin.relocate.incendo.cloud.type.range.Range;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.STABLE)
public final class FloatParser<C>
extends NumberParser<C, Float, FloatRange> {
    @API(status=API.Status.STABLE)
    public static final float DEFAULT_MINIMUM = Float.NEGATIVE_INFINITY;
    @API(status=API.Status.STABLE)
    public static final float DEFAULT_MAXIMUM = Float.POSITIVE_INFINITY;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Float> floatParser() {
        return FloatParser.floatParser(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Float> floatParser(float minValue) {
        return ParserDescriptor.of(new FloatParser<C>(minValue, Float.POSITIVE_INFINITY), Float.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Float> floatParser(float minValue, float maxValue) {
        return ParserDescriptor.of(new FloatParser<C>(minValue, maxValue), Float.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Float> floatComponent() {
        return CommandComponent.builder().parser(FloatParser.floatParser());
    }

    public FloatParser(float min2, float max) {
        super(Range.floatRange(min2, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Float> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidFloat((FloatRange)this.range())) {
            return ArgumentParseResult.failure(new FloatParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(Float.valueOf(commandInput.readFloat()));
    }

    @Override
    public boolean hasMax() {
        return ((FloatRange)this.range()).maxFloat() != Float.POSITIVE_INFINITY;
    }

    @Override
    public boolean hasMin() {
        return ((FloatRange)this.range()).minFloat() != Float.NEGATIVE_INFINITY;
    }

    @API(status=API.Status.STABLE)
    public static final class FloatParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public FloatParseException(@NonNull String input2, @NonNull FloatParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input2, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "float";
        }
    }
}

