/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize;

import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize.CoercionFailedException;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize.ScalarSerializer;
import app.simplecloud.signs.plugin.relocate.spongepowered.configurate.serialize.SerializationException;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CharSerializer
extends ScalarSerializer<Character> {
    CharSerializer() {
        super(Character.class);
    }

    @Override
    public Character deserialize(Type type, Object val) throws SerializationException {
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 1) {
                return Character.valueOf(strVal.charAt(0));
            }
            throw new SerializationException(type, "Only single character expected, but received " + strVal);
        }
        if (val instanceof Number) {
            return Character.valueOf((char)((Number)val).shortValue());
        }
        throw new CoercionFailedException(type, val, "char");
    }

    @Override
    public Object serialize(@NonNull Character item, Predicate<Class<?>> typeSupported) {
        if (typeSupported.test(Character.TYPE)) {
            return item;
        }
        return item.toString();
    }
}

