/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.parameters.options;

import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.parameters.options.Option;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parsers.OptionInvocation;
import com.github.ajalt.clikt.sources.ValueSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u001a,\u0010\u0005\u001a\u0004\u0018\u00010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0000\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\fH\u0001\u001a2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\"\u0010\u0013\u001a\u00020\u0014*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u001a\u001c\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a&\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0002\u00a8\u0006\u0017"}, d2={"inferOptionNames", "", "", "names", "propertyName", "inferEnvvar", "envvar", "autoEnvvarPrefix", "splitOptionPrefix", "Lkotlin/Pair;", "name", "longestName", "Lcom/github/ajalt/clikt/parameters/options/Option;", "getFinalValue", "", "Lcom/github/ajalt/clikt/parsers/OptionInvocation;", "context", "Lcom/github/ajalt/clikt/core/Context;", "invocations", "hasEnvvarOrSourcedValue", "", "readValueSource", "readEnvVar", "clikt"})
@SourceDebugExtension(value={"SMAP\nOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Option.kt\ncom/github/ajalt/clikt/parameters/options/OptionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1#2:186\n1948#3,14:187\n1971#3,14:201\n1557#3:215\n1628#3,3:216\n*S KotlinDebug\n*F\n+ 1 Option.kt\ncom/github/ajalt/clikt/parameters/options/OptionKt\n*L\n127#1:187,14\n141#1:201,14\n177#1:215\n177#1:216,3\n*E\n"})
public final class OptionKt {
    @NotNull
    public static final Set<String> inferOptionNames(@NotNull Set<String> names, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter(names, "names");
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        if (!((Collection)names).isEmpty()) {
            Object v0;
            block3: {
                Iterable iterable = names;
                for (Object t2 : iterable) {
                    String it = (String)t2;
                    boolean bl = false;
                    CharSequence charSequence = it;
                    if (!(!new Regex("[\\-@/+]{1,2}(?:[\\w\\-_]+|\\?)").matches(charSequence))) continue;
                    v0 = t2;
                    break block3;
                }
                v0 = null;
            }
            String invalidName = v0;
            if (!(invalidName == null)) {
                boolean bl = false;
                String string = "Invalid option name \"" + invalidName + '\"';
                throw new IllegalArgumentException(string.toString());
            }
            return names;
        }
        StringBuilder stringBuilder = new StringBuilder().append("--");
        CharSequence charSequence = propertyName;
        Regex regex = new Regex("[a-z][A-Z]");
        Function1<MatchResult, CharSequence> function1 = OptionKt::inferOptionNames$lambda$2;
        String string = regex.replace(charSequence, function1).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String normalizedName = stringBuilder.append(string).toString();
        return SetsKt.setOf(normalizedName);
    }

    @Nullable
    public static final String inferEnvvar(@NotNull Set<String> names, @Nullable String envvar, @Nullable String autoEnvvarPrefix) {
        Object t2;
        Intrinsics.checkNotNullParameter(names, "names");
        String string = envvar;
        if (string != null) {
            return string;
        }
        if (names.isEmpty() || autoEnvvarPrefix == null) {
            return null;
        }
        Iterable $this$maxBy$iv = names;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = maxElem$iv;
        } else {
            String it = (String)maxElem$iv;
            boolean bl = false;
            int maxValue$iv = it.length();
            do {
                Object e$iv = iterator$iv.next();
                String it2 = (String)e$iv;
                $i$a$-maxByOrThrow-OptionKt$inferEnvvar$name$1 = false;
                int v$iv = it2.length();
                if (maxValue$iv >= v$iv) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = maxElem$iv;
        }
        String name = OptionKt.splitOptionPrefix((String)t2).getSecond();
        if (((CharSequence)name).length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append(autoEnvvarPrefix).append('_');
        CharSequence charSequence = name;
        Regex regex = new Regex("\\W");
        String string2 = "_";
        String string3 = regex.replace(charSequence, string2).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
        return stringBuilder.append(string3).toString();
    }

    @NotNull
    public static final Pair<String, String> splitOptionPrefix(@NotNull String name) {
        Pair<String, String> pair;
        Intrinsics.checkNotNullParameter(name, "name");
        if (name.length() < 2 || !StringsKt.contains$default((CharSequence)"-@/+", name.charAt(0), false, 2, null)) {
            pair = TuplesKt.to("", name);
        } else if (name.length() > 2 && name.charAt(0) == name.charAt(1)) {
            String string = StringsKt.slice(name, new IntRange(0, 1));
            String string2 = name.substring(2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            pair = TuplesKt.to(string, string2);
        } else {
            String string = name.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String string3 = name.substring(1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            pair = TuplesKt.to(string, string3);
        }
        return pair;
    }

    @PublishedApi
    @Nullable
    public static final String longestName(@NotNull Option $this$longestName) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$longestName, "<this>");
        Iterable $this$maxByOrNull$iv = $this$longestName.getNames();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                String it = (String)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.length();
                do {
                    Object e$iv = iterator$iv.next();
                    String it2 = (String)e$iv;
                    $i$a$-maxByOrNull-OptionKt$longestName$1 = false;
                    int v$iv = it2.length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    @NotNull
    public static final List<OptionInvocation> getFinalValue(@NotNull Option $this$getFinalValue, @NotNull Context context, @NotNull List<OptionInvocation> invocations, @Nullable String envvar) {
        List<OptionInvocation> list;
        List<OptionInvocation> list2;
        Intrinsics.checkNotNullParameter($this$getFinalValue, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(invocations, "invocations");
        if ($this$getFinalValue.getEager() || !((Collection)invocations).isEmpty()) {
            list2 = invocations;
        } else if (context.getReadEnvvarBeforeValueSource()) {
            list2 = OptionKt.readEnvVar($this$getFinalValue, context, envvar);
            if (list2 == null) {
                list2 = OptionKt.readValueSource($this$getFinalValue, context);
            }
        } else {
            list2 = OptionKt.readValueSource($this$getFinalValue, context);
            if (list2 == null) {
                list2 = list = OptionKt.readEnvVar($this$getFinalValue, context, envvar);
            }
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final boolean hasEnvvarOrSourcedValue(@NotNull Option $this$hasEnvvarOrSourcedValue, @NotNull Context context, @NotNull List<OptionInvocation> invocations) {
        Intrinsics.checkNotNullParameter($this$hasEnvvarOrSourcedValue, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(invocations, "invocations");
        if (!((Collection)invocations).isEmpty()) {
            return false;
        }
        OptionWithValues optionWithValues = $this$hasEnvvarOrSourcedValue instanceof OptionWithValues ? (OptionWithValues)$this$hasEnvvarOrSourcedValue : null;
        String envvar = optionWithValues != null ? optionWithValues.getEnvvar() : null;
        List<OptionInvocation> list = OptionKt.getFinalValue($this$hasEnvvarOrSourcedValue, context, invocations, envvar);
        return !((Collection)list).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<OptionInvocation> readValueSource(Option $this$readValueSource, Context context) {
        List list;
        List<ValueSource.Invocation> list2;
        ValueSource valueSource = context.getValueSource();
        if (valueSource != null && (list2 = valueSource.getValues(context, $this$readValueSource)) != null) {
            Iterable iterable;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable2 = list2;
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueSource.Invocation invocation = (ValueSource.Invocation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new OptionInvocation("", it.getValues()));
            }
            iterable2 = (List)destination$iv$iv;
            if (iterable2.isEmpty()) {
                boolean bl = false;
                iterable = null;
            } else {
                iterable = iterable2;
            }
            list = (List)iterable;
        } else {
            list = null;
        }
        return list;
    }

    private static final List<OptionInvocation> readEnvVar(Option $this$readEnvVar, Context context, String envvar) {
        List<OptionInvocation> list;
        String string = OptionKt.inferEnvvar($this$readEnvVar.getNames(), envvar, context.getAutoEnvvarPrefix());
        if (string == null) {
            return null;
        }
        String env = string;
        String string2 = context.getReadEnvvar().invoke(env);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            list = CollectionsKt.listOf(new OptionInvocation(env, CollectionsKt.listOf(it)));
        } else {
            list = null;
        }
        return list;
    }

    private static final CharSequence inferOptionNames$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "" + it.getValue().charAt(0) + '-' + it.getValue().charAt(1);
    }
}

